package com.jhscale.common.model.device.polymerization.inner;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.utils.ByteUtils;

import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYMemberUser
 * @description
 * @create 2024/2/1 9:12
 */
public class JKYMemberUser extends AggregatedEntity {

    // 套餐编号
    private String kid;

    // 用户吉卡云标识
    private String userKid;

    // 用户标识
    private long userSign;

    // 用户头像
    private String picture;

    // 用户名称
    private String userName;

    // 用户区号
    private String areaCode;

    // 用户帐号
    private String account;

    // 商户吉卡云标识
    private String merchantKid;

    // 商户标识
    private long merchantSign;

    // 商户名称
    private String merchantName;

    // 套餐状态
    private String state;

    // 套餐创建时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.kid))
                .append(ByteUtils.a_text(this.userKid))
                .append(ByteUtils.long2Hex(this.userSign, 16))
                .append(ByteUtils.a_text(this.picture))
                .append(ByteUtils.a_text(this.userName))
                .append(ByteUtils.a_text(this.areaCode))
                .append(ByteUtils.a_text(this.account))
                .append(ByteUtils.a_text(this.merchantKid))
                .append(ByteUtils.long2Hex(this.merchantSign, 16))
                .append(ByteUtils.a_text(this.merchantName))
                .append(ByteUtils.a_text(this.state))
                .append(ByteUtils.timeToStr(this.createTime));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.kid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.userKid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.userSign = ByteUtils.hex2Long(innerContent.substring(0, 16));
        innerContent = innerContent.substring(16);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.picture = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.userName = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.areaCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.account = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.merchantKid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.merchantSign = ByteUtils.hex2Long(innerContent.substring(0, 16));
        innerContent = innerContent.substring(16);


        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.merchantName = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }


        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.state = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.createTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        return innerContent;
    }

    public String getKid() {
        return kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getUserKid() {
        return userKid;
    }

    public void setUserKid(String userKid) {
        this.userKid = userKid;
    }

    public long getUserSign() {
        return userSign;
    }

    public void setUserSign(long userSign) {
        this.userSign = userSign;
    }

    public String getPicture() {
        return picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getMerchantKid() {
        return merchantKid;
    }

    public void setMerchantKid(String merchantKid) {
        this.merchantKid = merchantKid;
    }

    public long getMerchantSign() {
        return merchantSign;
    }

    public void setMerchantSign(long merchantSign) {
        this.merchantSign = merchantSign;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
