package com.jhscale.common.model.device.polymerization.inner;

import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYMerchantSetting
 * @description
 * @create 2024/2/1 9:46
 */
public class JKYMerchantSetting extends AggregatedEntity {

    // id
    private int id;

    // 0:积分 1：充值 2：折扣/特价 3：折扣/特价允许降级 4.手机号允许储值支付 5：允许现场支付 6：允许混合支付 7：充值赠送
    private String code;

    // 是否启用 0：不启用 1：启用
    private int enable;

    // 是否启用 0：正常显示 1：不显示
    private String state;

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2HexWithPush(this.id, 8))
                .append(ByteUtils.a_text(this.code))
                .append(ByteUtils.int2Hex(this.enable))
                .append(ByteUtils.a_text(this.state));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.id = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.code = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.enable = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.state = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getEnable() {
        return enable;
    }

    public void setEnable(int enable) {
        this.enable = enable;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }
}
