package com.jhscale.common.model.device.polymerization.inner;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title RechargeMeal
 * @description
 * @create 2024/2/1 11:00
 */
public class JKYRechargeSetMeal extends AggregatedEntity {

    // 套餐的kid
    private String kid;

    // 套餐名称
    private String name;

    // 商户的套餐排序
    private int mealOrder;

    // 设置套餐的用户初始等级
    private int grade;

    // 充值金额
    private BigDecimal rechargeAmount;

    // 赠送金额
    private BigDecimal donationAmount;

    // 充送扣费比
    private String takeChargeFee;

    // 赠送过期时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date donationExpireTime;

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.kid))
                .append(ByteUtils.a_text(this.name))
                .append(ByteUtils.int2HexWithPush(this.mealOrder, 8))
                .append(ByteUtils.int2Hex(this.grade))
                .append(ByteUtils.toSPFStrNone(this.rechargeAmount))
                .append(ByteUtils.toSPFStrNone(this.donationAmount))
                .append(ByteUtils.a_text(this.takeChargeFee))
                .append(ByteUtils.timeToStr(this.donationExpireTime));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.kid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.name = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.mealOrder = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.grade = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.rechargeAmount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.donationAmount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.takeChargeFee = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.donationExpireTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        return innerContent;
    }

    public String getKid() {
        return kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMealOrder() {
        return mealOrder;
    }

    public void setMealOrder(int mealOrder) {
        this.mealOrder = mealOrder;
    }

    public int getGrade() {
        return grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public BigDecimal getRechargeAmount() {
        return rechargeAmount;
    }

    public void setRechargeAmount(BigDecimal rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }

    public BigDecimal getDonationAmount() {
        return donationAmount;
    }

    public void setDonationAmount(BigDecimal donationAmount) {
        this.donationAmount = donationAmount;
    }

    public String getTakeChargeFee() {
        return takeChargeFee;
    }

    public void setTakeChargeFee(String takeChargeFee) {
        this.takeChargeFee = takeChargeFee;
    }

    public Date getDonationExpireTime() {
        return donationExpireTime;
    }

    public void setDonationExpireTime(Date donationExpireTime) {
        this.donationExpireTime = donationExpireTime;
    }
}
