package com.jhscale.common.model.device.polymerization.jky;

import com.jhscale.common.model.device.polymerization.em.LoginType;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title LoginRequest
 * @description
 * @create 2024/1/25 10:25
 */
public class JKYLoginRequest extends AggregatedEntity {

    // 1. 登陆类型 A-小程序条码登陆|B-实体卡内部ID登陆|C-手机号登陆|D-手机号注册登陆
    private String type;

    // 2. 文本内容 A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String text;

    // 3. 自增序列 B-实体卡内部ID登陆-自增序列
    private Long number;

    // 4. 外部卡号 B-实体卡内部ID登陆-外部卡号|C-手机号登陆-手机区号[不传默认商家区号]
    private String text1;

    public JKYLoginRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYLoginRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder()
                .append(ByteUtils.toHexString(new byte[]{(byte) type.charAt(0)}));
        LoginType loginType = LoginType.type(this.type);
        switch (Objects.requireNonNull(loginType)) {
            case 小程序登陆:
                builder.append(ByteUtils.a_text(this.text));
                break;
            case 实体卡登陆:
                builder.append(ByteUtils.a_text(this.text))
                        .append(ByteUtils.long2Hex(this.number, 8))
                        .append(ByteUtils.a_text(this.text1));
                break;
            case 手机号码登陆:
                builder.append(ByteUtils.a_text(this.text));
                break;
            case 手机号注册登陆:
                builder.append(ByteUtils.a_text(this.text));
                break;
        }
        return builder;
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.type = new String(ByteUtils.fromHexString(innerContent.substring(0, 2)));
        innerContent = innerContent.substring(2);

        LoginType loginType = LoginType.type(this.type);
        int index = -1;
        switch (Objects.requireNonNull(loginType)) {
            case 小程序登陆:
            case 手机号码登陆:
            case 手机号注册登陆:
                index = ByteUtils.indexOf(innerContent, "00");
                if (index != -1) {
                    this.text = ByteUtils.p_text(innerContent.substring(0, index + 2));
                    innerContent = innerContent.substring(index + 2);
                }
                break;
            case 实体卡登陆:
                index = ByteUtils.indexOf(innerContent, "00");
                if (index != -1) {
                    this.text = ByteUtils.p_text(innerContent.substring(0, index + 2));
                    innerContent = innerContent.substring(index + 2);
                }

                this.number = ByteUtils.hex2Long(innerContent.substring(0, 8));
                innerContent = innerContent.substring(8);

                index = ByteUtils.indexOf(innerContent, "00");
                if (index != -1) {
                    this.text1 = ByteUtils.p_text(innerContent.substring(0, index + 2));
                    innerContent = innerContent.substring(index + 2);
                }
                break;
        }

        return innerContent;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Long getNumber() {
        return number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    public String getText1() {
        return text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }
}
