package com.jhscale.common.model.device.polymerization.jky;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.em.SwitchState;
import com.jhscale.common.model.device.polymerization.em.TradeEnv;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.StringUtil;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYLoginResponse
 * @description
 * @create 2024/1/25 12:16
 */
public class JKYLoginResponse extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. com.jhscale.common.model.device.polymerization.em.ChannelStatus
    private int code;

    // 3. 登出错误码
    private String errCode;

    // 4. 登出错误描述
    private String errMsg;

    // 5. 登陆类型 A-小程序条码登陆|B-实体卡内部ID登陆|C-手机号登陆|D-手机号注册登陆
    private String type;

    // 6. 卡号
    private String card;

    // 7. 1-A-允许所有扣款方式|2-B-允许储值扣款和储值混合扣款|3-C-只允许储值扣款|4-D-只允许现金扣款——交易情况=B/C时，如果余额=0，会自动进入冲值界面，如果交易情况=B，且余额不足时，会自动进入冲值界面
    private int tradeEnv;

    // 8. 卡等级
    private int level;

    // 9. 特价情况
    private String specialType;

    // 10. 折扣情况
    private BigDecimal discount;

    // 11. 可用余额
    private BigDecimal balance;

    // 12. 可用赠送余额
    private BigDecimal giveBalance;

    // 13. 赠送余额到期时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date giveBalanceTime;

    // 14. 可用积分
    private BigDecimal integral;

    // 15. 套餐卡号
    private String cardKid;

    // 16. 对应的手机
    private String operatorMobile;

    // 17. 操作用户头像
    private String operatorPic;

    // 18. 允许现金支付 0-未开启 1-已开启
    private Integer enableCash;

    // 19. 允许积分 0-未开启 1-已开启
    private Integer enableIntegral;

    // 20. 混合支付 0-未开启 1-已开启
    private Integer enableBlend;

    // 21. 允许手机号登陆 0-未开启 1-已开启
    private Integer enablePhone;

    // 22. 手机号支付限额
    private BigDecimal phoneFreePay;

    public JKYLoginResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYLoginResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2HexWithPush(this.code, 4))
                .append(ByteUtils.toHexString(new byte[]{(byte) type.charAt(0)}))
                .append(ByteUtils.a_text(this.card))
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg));
        TradeEnv env = TradeEnv.status(this.tradeEnv);
        if (Objects.nonNull(env)) {
            builder.append(ByteUtils.int2Hex(this.tradeEnv))
                    .append(ByteUtils.int2Hex(this.level))
                    .append(ByteUtils.a_text(this.specialType))
                    .append(ByteUtils.toSPFStrNone(this.discount))
                    .append(ByteUtils.toSPFStrNone(this.balance))
                    .append(ByteUtils.toSPFStrNone(this.giveBalance))
                    .append(ByteUtils.timeToStrNone(this.giveBalanceTime))
                    .append(ByteUtils.toSPFStrNone(this.integral))
                    .append(ByteUtils.a_text(this.cardKid))
                    .append(ByteUtils.a_text(this.operatorMobile))
                    .append(ByteUtils.a_text(this.operatorPic));
            String enable = "0000000000000000";
            if (SwitchState.启用.equals(SwitchState.switchState(this.enableCash)))
                enable = StringUtil.replace(enable, 0, '1');
            if (SwitchState.启用.equals(SwitchState.switchState(this.enableIntegral)))
                enable = StringUtil.replace(enable, 1, '1');
            if (SwitchState.启用.equals(SwitchState.switchState(this.enableBlend)))
                enable = StringUtil.replace(enable, 2, '1');
            if (SwitchState.启用.equals(SwitchState.switchState(this.enablePhone)))
                enable = StringUtil.replace(enable, 3, '1');

            builder.append(ByteUtils.binaryToHex(enable, 4))
                    .append(ByteUtils.toSPFStrNone(this.phoneFreePay));
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        return builder;
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        this.type = new String(ByteUtils.fromHexString(innerContent.substring(0, 2)));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.card = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.tradeEnv = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        TradeEnv env = TradeEnv.status(this.tradeEnv);
        if (Objects.nonNull(env)) {
            this.level = ByteUtils.hex2Ten(innerContent.substring(0, 2));
            innerContent = innerContent.substring(2);

            index = ByteUtils.indexOf(innerContent, "00");
            if (index != -1) {
                this.specialType = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }

            this.discount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);

            this.balance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);

            this.giveBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);

            this.giveBalanceTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);

            this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);

            index = ByteUtils.indexOf(innerContent, "00");
            if (index != -1) {
                this.cardKid = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }

            index = ByteUtils.indexOf(innerContent, "00");
            if (index != -1) {
                this.operatorMobile = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }

            index = ByteUtils.indexOf(innerContent, "00");
            if (index != -1) {
                this.operatorPic = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }

            String binary = ByteUtils.hexToBinary(innerContent.substring(0, 4), 16);
            innerContent = innerContent.substring(4);

            this.enableCash = SwitchState.switchState(binary.charAt(0)).enable();
            this.enableIntegral = SwitchState.switchState(binary.charAt(1)).enable();
            this.enableBlend = SwitchState.switchState(binary.charAt(2)).enable();
            this.enablePhone = SwitchState.switchState(binary.charAt(3)).enable();

            this.phoneFreePay = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);
        }

        return innerContent;
    }

    public BigDecimal discount() {
        return Objects.nonNull(this.discount) ? this.discount : BigDecimal.ONE;
    }

    public BigDecimal balance() {
        return Objects.nonNull(this.balance) ? this.balance : BigDecimal.ZERO;
    }

    public BigDecimal giveBalance() {
        return Objects.nonNull(this.giveBalance) ? this.giveBalance : BigDecimal.ZERO;
    }

    public Date giveBalanceTime() {
        return Objects.nonNull(this.giveBalanceTime) ? this.giveBalanceTime : new Date(DateUtils.TIME_2000_1_1_0_0_0);
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }

    public BigDecimal phoneFreePay() {
        return Objects.nonNull(this.phoneFreePay) ? this.phoneFreePay : BigDecimal.ZERO;
    }

    /**
     * @description: 总储值余额
     **/
    public BigDecimal getTotalBalance() {
        return this.balance().add(this.giveBalance());
    }

    /**
     * @description: 是否赠送永久有效
     **/
    public boolean isGiveForever() {
        return ByteUtils.isGiveForever(this.giveBalance, this.giveBalanceTime);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getTradeEnv() {
        return tradeEnv;
    }

    public void setTradeEnv(int tradeEnv) {
        this.tradeEnv = tradeEnv;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getSpecialType() {
        return specialType;
    }

    public void setSpecialType(String specialType) {
        this.specialType = specialType;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getGiveBalance() {
        return giveBalance;
    }

    public void setGiveBalance(BigDecimal giveBalance) {
        this.giveBalance = giveBalance;
    }

    public Date getGiveBalanceTime() {
        return giveBalanceTime;
    }

    public void setGiveBalanceTime(Date giveBalanceTime) {
        this.giveBalanceTime = giveBalanceTime;
    }

    public BigDecimal getIntegral() {
        return integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public String getCardKid() {
        return cardKid;
    }

    public void setCardKid(String cardKid) {
        this.cardKid = cardKid;
    }

    public String getCard() {
        return card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public String getOperatorMobile() {
        return operatorMobile;
    }

    public void setOperatorMobile(String operatorMobile) {
        this.operatorMobile = operatorMobile;
    }

    public String getOperatorPic() {
        return operatorPic;
    }

    public void setOperatorPic(String operatorPic) {
        this.operatorPic = operatorPic;
    }

    public Integer getEnableCash() {
        return enableCash;
    }

    public void setEnableCash(Integer enableCash) {
        this.enableCash = enableCash;
    }

    public Integer getEnableIntegral() {
        return enableIntegral;
    }

    public void setEnableIntegral(Integer enableIntegral) {
        this.enableIntegral = enableIntegral;
    }

    public Integer getEnableBlend() {
        return enableBlend;
    }

    public void setEnableBlend(Integer enableBlend) {
        this.enableBlend = enableBlend;
    }

    public Integer getEnablePhone() {
        return enablePhone;
    }

    public void setEnablePhone(Integer enablePhone) {
        this.enablePhone = enablePhone;
    }

    public BigDecimal getPhoneFreePay() {
        return phoneFreePay;
    }

    public void setPhoneFreePay(BigDecimal phoneFreePay) {
        this.phoneFreePay = phoneFreePay;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
