package com.jhscale.common.model.device.polymerization.jky;

import com.jhscale.common.model.device.polymerization.em.ChannelStatus;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYLoginResponse
 * @description
 * @create 2024/1/25 12:16
 */
public class JKYLogoutResponse extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. 状态 20-成功 21|其余失败
    private int code;

    // 3. 登出错误码
    private String errCode;

    // 4. 登出错误描述
    private String errMsg;

    public JKYLogoutResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYLogoutResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2Hex(this.code))
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg));
        return builder;
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    /**
     * @description: 登出结果
     **/
    public boolean result() {
        return ChannelStatus.登出成功.getCode() == this.code;
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
