package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYPaymentRequest
 * @description
 * @create 2024/1/25 12:15
 */
public class JKYCancelQueryRequest extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    public JKYCancelQueryRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYCancelQueryRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }
}
