package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.JKYIntegralSetMeal;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title IntegralMeal
 * @description
 * @create 2024/2/1 11:01
 */
public class JKYIntegralSetMealResponse extends AggregatedEntity {

    // 积分套餐版本
    private int mealVersion;

    // 积分套餐猎豹
    private List<JKYIntegralSetMeal> setMeals;

    public JKYIntegralSetMealResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYIntegralSetMealResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder()
                .append(ByteUtils.int2HexWithPush(this.mealVersion, 8));

        if (this.setMeals != null && !this.setMeals.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.setMeals.size()));
            for (JKYIntegralSetMeal setMeal : this.setMeals) {
                builder.append(setMeal.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        return builder;
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        if (size > 0) {
            this.setMeals = new ArrayList<>();
            for (int i = 0; i < size; i++) {
                JKYIntegralSetMeal setMeal = new JKYIntegralSetMeal();
                innerContent = setMeal.inner_analyse(innerContent);
                this.setMeals.add(setMeal);
            }
        }
        return innerContent;
    }

    public int getMealVersion() {
        return mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public List<JKYIntegralSetMeal> getSetMeals() {
        return setMeals;
    }

    public void setSetMeals(List<JKYIntegralSetMeal> setMeals) {
        this.setMeals = setMeals;
    }
}
