package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.*;
import com.jhscale.common.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title RechargeMeal
 * @description
 * @create 2024/2/1 11:00
 */
public class JKYRechargeSetMealResponse extends AggregatedEntity {

    // 商家充值套餐版本
    private int mealVersion;

    // 商家充值套餐内容
    private List<JKYRechargeSetMeal> setMeals;

    // 商家会员属性
    private JKYSettingListResponse settingList;

    public JKYRechargeSetMealResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYRechargeSetMealResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder()
                .append(ByteUtils.int2HexWithPush(this.mealVersion, 8));
        if (this.setMeals != null && !this.setMeals.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.setMeals.size()));
            for (JKYRechargeSetMeal setMeal : this.setMeals) {
                builder.append(setMeal.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }

        if (Objects.nonNull(this.settingList)) builder.append(this.settingList.inner_assembly());
        return builder;
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        if (size > 0) {
            this.setMeals = new ArrayList<>();
            for (int i = 0; i < size; i++) {
                JKYRechargeSetMeal setMeal = new JKYRechargeSetMeal();
                innerContent = setMeal.inner_analyse(innerContent);
                this.setMeals.add(setMeal);
            }
        }

        if (StringUtils.isNotBlank(innerContent)) {
            JKYSettingListResponse settingList = new JKYSettingListResponse();
            innerContent = settingList.inner_analyse(innerContent);
            this.settingList = settingList;
        }
        return innerContent;
    }

    public int getMealVersion() {
        return mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public List<JKYRechargeSetMeal> getSetMeals() {
        return setMeals;
    }

    public void setSetMeals(List<JKYRechargeSetMeal> setMeals) {
        this.setMeals = setMeals;
    }

    public JKYSettingListResponse getSettingList() {
        return settingList;
    }

    public void setSettingList(JKYSettingListResponse settingList) {
        this.settingList = settingList;
    }
}
