package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.*;
import com.jhscale.common.utils.ByteUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYSettingList
 * @description
 * @create 2024/2/1 9:44
 */
public class JKYSettingListResponse extends AggregatedEntity {

    // 市场编号
    private long merchantSign;

    // 商户kid
    private String merchantKid;

    // 全局设置
    private List<JKYMerchantSetting> settingList;

    // 等级优惠设置
    private List<JKYDiscountLevel> levelList;

    // 其他设置参数 (1-积分倍数 2-卡号使用共享还是独立 3-手机号免密支付金额)
    private Map<String, String> otherParams;

    public JKYSettingListResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYSettingListResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder();
        builder.append(ByteUtils.long2Hex(this.merchantSign, 16))
                .append(ByteUtils.a_text(this.merchantKid));

        if (this.settingList != null && !this.settingList.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.settingList.size()));
            for (JKYMerchantSetting setting : this.settingList) {
                builder.append(setting.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }

        if (this.levelList != null && !this.levelList.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.levelList.size()));
            for (JKYDiscountLevel level : this.levelList) {
                builder.append(level.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }

        if (this.otherParams != null && !this.otherParams.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.otherParams.size()));
            for (Map.Entry<String, String> entry : this.otherParams.entrySet()) {
                builder.append(ByteUtils.a_text(entry.getKey()))
                        .append(ByteUtils.a_text(entry.getValue()));
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        return builder;
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.merchantSign = ByteUtils.hex2Long(innerContent.substring(0, 16));
        innerContent = innerContent.substring(16);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.merchantKid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        int size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        if (size > 0) {
            this.settingList = new ArrayList<>();
            for (int i = 0; i < size; i++) {
                JKYMerchantSetting setting = new JKYMerchantSetting();
                innerContent = setting.inner_analyse(innerContent);
                this.settingList.add(setting);
            }
        }

        size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        if (size > 0) {
            this.levelList = new ArrayList<>();
            for (int i = 0; i < size; i++) {
                JKYDiscountLevel level = new JKYDiscountLevel();
                innerContent = level.inner_analyse(innerContent);
                this.levelList.add(level);
            }
        }

        size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        if (size > 0) {
            this.otherParams = new HashMap<>();
            for (int i = 0; i < size; i++) {
                String key = null, value = null;
                index = ByteUtils.indexOf(innerContent, "00");
                if (index != -1) {
                    key = ByteUtils.p_text(innerContent.substring(0, index + 2));
                    innerContent = innerContent.substring(index + 2);
                }

                index = ByteUtils.indexOf(innerContent, "00");
                if (index != -1) {
                    value = ByteUtils.p_text(innerContent.substring(0, index + 2));
                    innerContent = innerContent.substring(index + 2);
                }

                this.otherParams.put(key, value);
            }
        }
        return innerContent;
    }

    public long getMerchantSign() {
        return merchantSign;
    }

    public void setMerchantSign(long merchantSign) {
        this.merchantSign = merchantSign;
    }

    public String getMerchantKid() {
        return merchantKid;
    }

    public void setMerchantKid(String merchantKid) {
        this.merchantKid = merchantKid;
    }

    public List<JKYMerchantSetting> getSettingList() {
        return settingList;
    }

    public void setSettingList(List<JKYMerchantSetting> settingList) {
        this.settingList = settingList;
    }

    public List<JKYDiscountLevel> getLevelList() {
        return levelList;
    }

    public void setLevelList(List<JKYDiscountLevel> levelList) {
        this.levelList = levelList;
    }

    public Map<String, String> getOtherParams() {
        return otherParams;
    }

    public void setOtherParams(Map<String, String> otherParams) {
        this.otherParams = otherParams;
    }
}
