package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYPaymentRequest
 * @description
 * @create 2024/1/25 12:15
 */
public class JKYUserQueryRequest extends AggregatedEntity {

    // 1. 手机号后几位查询用户信息 长度 >= 4
    private String text;

    public JKYUserQueryRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYUserQueryRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.text));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.text = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }
}
