package com.jhscale.common.model.device.polymerization.jky.trade;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYPaymentRequest
 * @description
 * @create 2024/1/25 12:15
 */
public class JKYIntegralRequest extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. FID 4字节
    private int fid;

    // 3. 兑换方式 0 套餐兑换 1-自定义兑换
    private int type;

    // 4. 积分套餐版本号
    private int mealVersion;

    // 5. 积分套餐序号
    private int mealOrder;

    // 7. 使用过积分(实际消耗的积分 套餐兑换可以为空)
    private BigDecimal integral;

    // 8. 使用过积分备注
    private String remark;

    // 9. 随机字节 2字节
    private int random = RandomUtils.integer_random(65535);

    // 10. 兑换数量
    private int count = 1;

    // 11. 重发序号 1字节
    private int retryCount;

    public JKYIntegralRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYIntegralRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.int2Hex(this.type))
                .append(ByteUtils.int2HexWithPush(this.mealVersion, 8))
                .append(ByteUtils.int2HexWithPush(this.mealOrder, 8))
                .append(ByteUtils.toSPFStrNone(this.integral))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.int2HexWithPush(this.random, 4))
                .append(ByteUtils.int2Hex(this.count))
                .append(ByteUtils.int2Hex(this.retryCount));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.type = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.mealOrder = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        this.count = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMealVersion() {
        return mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public int getMealOrder() {
        return mealOrder;
    }

    public void setMealOrder(int mealOrder) {
        this.mealOrder = mealOrder;
    }

    public BigDecimal getIntegral() {
        return integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getRandom() {
        return random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
