package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYLoginResponse
 * @description
 * @create 2024/1/25 12:16
 */
public class JKYIntegralResponse extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. com.jhscale.common.model.device.polymerization.em.ChannelStatus
    private int code;

    // 3. FID 4字节
    private int fid;

    // 4. 系统单号
    private String orderNo;

    // 5. 完成时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expire;

    // 5. 错误码
    private String errCode;

    // 6. 错误描述
    private String errMsg;

    // 7. 交易类型
    private int tradeType;

    // 8. 使用积分
    private BigDecimal integral;

    // 9. 积分兑换前总余额
    private BigDecimal beforeBalance;

    // 10. 积分兑换前赠送金额
    private BigDecimal beforeGiveMoney;

    // 11. 积分兑换前积分
    private BigDecimal beforeIntegral;

    // 12. 积分兑换后总余额
    private BigDecimal afterBalance;

    // 13. 积分兑换后赠送金额
    private BigDecimal afterGiveMoney;

    // 14. 积分兑换后积分
    private BigDecimal afterIntegral;

    // 15. 积分兑换后赠送金额有效期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date giveBalanceTime;

    // 16. 账单说明
    private String description;

    public JKYIntegralResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYIntegralResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2Hex(this.code))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.a_text(this.orderNo))
                .append(ByteUtils.timeToStrNone(this.expire))
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg))
                .append(ByteUtils.int2Hex(this.tradeType))
                .append(ByteUtils.toSPFStrNone(this.integral))
                .append(ByteUtils.toSPFStrNone(this.beforeBalance))
                .append(ByteUtils.toSPFStrNone(this.beforeGiveMoney))
                .append(ByteUtils.toSPFStrNone(this.beforeIntegral))
                .append(ByteUtils.toSPFStrNone(this.afterBalance))
                .append(ByteUtils.toSPFStrNone(this.afterGiveMoney))
                .append(ByteUtils.toSPFStrNone(this.afterIntegral))
                .append(ByteUtils.timeToStrNone(this.giveBalanceTime))
                .append(ByteUtils.a_text(this.description));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.tradeType = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.afterBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.afterGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.afterIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.giveBalanceTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.description = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        return innerContent;
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }


    public BigDecimal beforeBalance() {
        return Objects.nonNull(this.beforeBalance) ? this.beforeBalance : BigDecimal.ZERO;
    }

    public BigDecimal beforeGiveMoney() {
        return Objects.nonNull(this.beforeGiveMoney) ? this.beforeGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal beforeTotal() {
        return this.beforeBalance().add(this.beforeGiveMoney());
    }

    public BigDecimal beforeIntegral() {
        return Objects.nonNull(this.beforeIntegral) ? this.beforeIntegral : BigDecimal.ZERO;
    }

    public BigDecimal afterBalance() {
        return Objects.nonNull(this.afterBalance) ? this.afterBalance : BigDecimal.ZERO;
    }

    public BigDecimal afterGiveMoney() {
        return Objects.nonNull(this.afterGiveMoney) ? this.afterGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal afterTotal() {
        return this.afterBalance().add(this.afterGiveMoney());
    }

    public BigDecimal afterIntegral() {
        return Objects.nonNull(this.afterIntegral) ? this.afterIntegral : BigDecimal.ZERO;
    }

    /**
     * @description: 是否赠送永久有效
     **/
    public boolean isGiveForever() {
        return ByteUtils.isGiveForever(this.afterGiveMoney, this.giveBalanceTime);
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getExpire() {
        return expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public int getTradeType() {
        return tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public BigDecimal getIntegral() {
        return integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public BigDecimal getBeforeBalance() {
        return beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getBeforeGiveMoney() {
        return beforeGiveMoney;
    }

    public void setBeforeGiveMoney(BigDecimal beforeGiveMoney) {
        this.beforeGiveMoney = beforeGiveMoney;
    }

    public BigDecimal getBeforeIntegral() {
        return beforeIntegral;
    }

    public void setBeforeIntegral(BigDecimal beforeIntegral) {
        this.beforeIntegral = beforeIntegral;
    }

    public BigDecimal getAfterBalance() {
        return afterBalance;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public BigDecimal getAfterGiveMoney() {
        return afterGiveMoney;
    }

    public void setAfterGiveMoney(BigDecimal afterGiveMoney) {
        this.afterGiveMoney = afterGiveMoney;
    }

    public BigDecimal getAfterIntegral() {
        return afterIntegral;
    }

    public void setAfterIntegral(BigDecimal afterIntegral) {
        this.afterIntegral = afterIntegral;
    }

    public Date getGiveBalanceTime() {
        return giveBalanceTime;
    }

    public void setGiveBalanceTime(Date giveBalanceTime) {
        this.giveBalanceTime = giveBalanceTime;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
