package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYLoginResponse
 * @description
 * @create 2024/1/25 12:16
 */
public class JKYPayResponse extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 3. com.jhscale.common.model.device.polymerization.em.ChannelStatus
    private int code;

    // 3. FID 4字节
    private int fid;

    // 4. 系统单号
    private String orderNo;

    // 5. 完成时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expire;

    // 5. 错误码
    private String errCode;

    // 6. 错误描述
    private String errMsg;

    // 7. 交易类型
    private int tradeType;

    // 8. 吉卡云扣款金额(储值+赠送)
    private BigDecimal stored;

    // 9. 现金支付金额
    private BigDecimal cash;

    // 10. 云支付金额
    private BigDecimal cloud;

    // 11. 其他方式金额(cash+cloud)
    private BigDecimal amount;

    // 12. 实际总支付金额(stored+amount)
    private BigDecimal actual;

    // 13. 储值扣款金额(储值)
    private BigDecimal balance;

    // 14. 赠送扣款金额
    private BigDecimal giveMoney;

    // 15. 获取积分
    private BigDecimal integral;

    // 16. 储值剩余金额
    private BigDecimal surplusMoney;

    // 17. 赠送剩余金额
    private BigDecimal surplusGiveMoney;

    // 18. 剩余积分
    private BigDecimal surplusIntegral;

    // 19. 支付渠道
    private int payWay;

    // 20. 支付类型
    private int payType;

    // 21. 第三方支付单号
    private String cloudTradeNo;

    public JKYPayResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYPayResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2Hex(this.code))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.a_text(this.orderNo))
                .append(ByteUtils.timeToStrNone(this.expire))
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg))
                .append(ByteUtils.int2Hex(this.tradeType))
                .append(ByteUtils.toSPFStrNone(this.stored))
                .append(ByteUtils.toSPFStrNone(this.cash))
                .append(ByteUtils.toSPFStrNone(this.cloud))
                .append(ByteUtils.toSPFStrNone(this.amount))
                .append(ByteUtils.toSPFStrNone(this.actual))
                .append(ByteUtils.toSPFStrNone(this.balance))
                .append(ByteUtils.toSPFStrNone(this.giveMoney))
                .append(ByteUtils.toSPFStrNone(this.integral))
                .append(ByteUtils.toSPFStrNone(this.surplusMoney))
                .append(ByteUtils.toSPFStrNone(this.surplusGiveMoney))
                .append(ByteUtils.toSPFStrNone(this.surplusIntegral))
                .append(ByteUtils.int2HexWithPush(this.payWay, 4))
                .append(ByteUtils.int2HexWithPush(this.payType, 4))
                .append(ByteUtils.a_text(this.cloudTradeNo));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.tradeType = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.stored = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.cloud = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.actual = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.balance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.giveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.surplusMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.surplusGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.surplusIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.payWay = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        this.payType = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.cloudTradeNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public BigDecimal stored() {
        return Objects.nonNull(this.stored) ? this.stored : BigDecimal.ZERO;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal cloud() {
        return Objects.nonNull(this.cloud) ? this.cloud : BigDecimal.ZERO;
    }

    public BigDecimal amount() {
        return Objects.nonNull(this.amount) ? this.amount : this.cash().add(this.cloud());
    }

    public BigDecimal actual() {
        return Objects.nonNull(this.actual) ? this.actual : BigDecimal.ZERO;
    }

    public BigDecimal balance() {
        return Objects.nonNull(this.balance) ? this.balance : BigDecimal.ZERO;
    }

    public BigDecimal giveMoney() {
        return Objects.nonNull(this.giveMoney) ? this.giveMoney : BigDecimal.ZERO;
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }

    public BigDecimal surplusMoney() {
        return Objects.nonNull(this.surplusMoney) ? this.surplusMoney : BigDecimal.ZERO;
    }

    public BigDecimal surplusGiveMoney() {
        return Objects.nonNull(this.surplusGiveMoney) ? this.surplusGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal surplusIntegral() {
        return Objects.nonNull(this.surplusIntegral) ? this.surplusIntegral : BigDecimal.ZERO;
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getExpire() {
        return expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public int getTradeType() {
        return tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public BigDecimal getStored() {
        return stored;
    }

    public void setStored(BigDecimal stored) {
        this.stored = stored;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCloud() {
        return cloud;
    }

    public void setCloud(BigDecimal cloud) {
        this.cloud = cloud;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getActual() {
        return actual;
    }

    public void setActual(BigDecimal actual) {
        this.actual = actual;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getGiveMoney() {
        return giveMoney;
    }

    public void setGiveMoney(BigDecimal giveMoney) {
        this.giveMoney = giveMoney;
    }

    public BigDecimal getIntegral() {
        return integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public BigDecimal getSurplusMoney() {
        return surplusMoney;
    }

    public void setSurplusMoney(BigDecimal surplusMoney) {
        this.surplusMoney = surplusMoney;
    }

    public BigDecimal getSurplusGiveMoney() {
        return surplusGiveMoney;
    }

    public void setSurplusGiveMoney(BigDecimal surplusGiveMoney) {
        this.surplusGiveMoney = surplusGiveMoney;
    }

    public BigDecimal getSurplusIntegral() {
        return surplusIntegral;
    }

    public void setSurplusIntegral(BigDecimal surplusIntegral) {
        this.surplusIntegral = surplusIntegral;
    }

    public int getPayWay() {
        return payWay;
    }

    public void setPayWay(int payWay) {
        this.payWay = payWay;
    }

    public int getPayType() {
        return payType;
    }

    public void setPayType(int payType) {
        this.payType = payType;
    }

    public String getCloudTradeNo() {
        return cloudTradeNo;
    }

    public void setCloudTradeNo(String cloudTradeNo) {
        this.cloudTradeNo = cloudTradeNo;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
