package com.jhscale.common.model.device.polymerization.jky.trade;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYPaymentRequest
 * @description
 * @create 2024/1/25 12:15
 */
public class JKYRechargeRequest extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. FID 4字节
    private int fid;

    // 3. 充值方式 0 默认套餐充值 1-自定义充值
    private int type;

    // 4. 充值套餐版本号
    private int mealVersion;

    // 5. 充值套餐序号
    private int mealOrder;

    // 6. 现金充值金额
    private BigDecimal cash;

    // 7. 云支付金额
    private BigDecimal cloud;

    // 8. 云支付金额 支付码
    private String paycode;

    // 9. 赠送金额
    private BigDecimal give;

    // 10. 金额赠送金额有效天数（0 代表永久有效 不传永久）[自定义充值有效]
    private int expireTime;

    // 11. 充值备注
    private String remark;

    // 12. 随机字节 2字节
    private int random = RandomUtils.integer_random(65535);

    // 13. 重发序号 1字节
    private int retryCount;

    public JKYRechargeRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYRechargeRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.int2Hex(this.type))
                .append(ByteUtils.int2HexWithPush(this.mealVersion, 8))
                .append(ByteUtils.int2HexWithPush(this.mealOrder, 8))
                .append(ByteUtils.toSPFStrNone(this.cash))
                .append(ByteUtils.toSPFStrNone(this.cloud))
                .append(ByteUtils.a_text(this.paycode))
                .append(ByteUtils.toSPFStrNone(this.give))
                .append(ByteUtils.int2HexWithPush(this.expireTime, 4))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.int2HexWithPush(this.random, 4))
                .append(ByteUtils.int2Hex(this.retryCount));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.type = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.mealOrder = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.cloud = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.paycode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.give = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.expireTime = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal cloud() {
        return Objects.nonNull(this.cloud) ? this.cloud : BigDecimal.ZERO;
    }

    /**
     * @description: 充值支付总额
     **/
    public BigDecimal amount() {
        return this.cash().add(this.cloud());
    }

    public BigDecimal give() {
        return Objects.nonNull(this.give) ? this.give : BigDecimal.ZERO;
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMealVersion() {
        return mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public int getMealOrder() {
        return mealOrder;
    }

    public void setMealOrder(int mealOrder) {
        this.mealOrder = mealOrder;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCloud() {
        return cloud;
    }

    public void setCloud(BigDecimal cloud) {
        this.cloud = cloud;
    }

    public String getPaycode() {
        return paycode;
    }

    public void setPaycode(String paycode) {
        this.paycode = paycode;
    }

    public BigDecimal getGive() {
        return give;
    }

    public void setGive(BigDecimal give) {
        this.give = give;
    }

    public int getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getRandom() {
        return random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
