package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.DateUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYLoginResponse
 * @description
 * @create 2024/1/25 12:16
 */
public class JKYRechargeResponse extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. com.jhscale.common.model.device.polymerization.em.ChannelStatus
    private int code;

    // 3. FID 4字节
    private int fid;

    // 4. 系统单号
    private String orderNo;

    // 5. 完成时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expire;

    // 5. 错误码
    private String errCode;

    // 6. 错误描述
    private String errMsg;

    // 7. 交易类型
    private int tradeType;

    // 9. 现金充值金额
    private BigDecimal cash;

    // 10. 云充值金额(cash+cloud)
    private BigDecimal cloud;

    // 8. 充值金额
    private BigDecimal amount;

    // 9. 充值前总余额
    private BigDecimal beforeBalance;

    // 10. 充值后总余额
    private BigDecimal afterBalance;

    // 11. 充值前赠送金额
    private BigDecimal beforeGiveMoney;

    // 12. 充值后赠送金额
    private BigDecimal afterGiveMoney;

    // 13. 赠送金额有效期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date giveMoneyTime;

    // 14. 卡等级
    private int level;

    // 15. 特价情况
    private String specialType;

    // 16. 折扣情况
    private BigDecimal discount;

    // 17. 支付渠道
    private int payWay;

    // 18. 支付类型
    private int payType;

    // 19. 第三方支付单号
    private String cloudTradeNo;

    public JKYRechargeResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYRechargeResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2Hex(this.code))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.a_text(this.orderNo))
                .append(ByteUtils.timeToStrNone(this.expire))
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg))
                .append(ByteUtils.int2Hex(this.tradeType))
                .append(ByteUtils.toSPFStrNone(this.cash))
                .append(ByteUtils.toSPFStrNone(this.cloud))
                .append(ByteUtils.toSPFStrNone(this.amount))
                .append(ByteUtils.toSPFStrNone(this.beforeBalance))
                .append(ByteUtils.toSPFStrNone(this.afterBalance))
                .append(ByteUtils.toSPFStrNone(this.beforeGiveMoney))
                .append(ByteUtils.toSPFStrNone(this.afterGiveMoney))
                .append(ByteUtils.timeToStrNone(this.giveMoneyTime))
                .append(ByteUtils.int2Hex(this.level))
                .append(ByteUtils.a_text(this.specialType))
                .append(ByteUtils.toSPFStrNone(this.discount))
                .append(ByteUtils.int2HexWithPush(this.payWay, 4))
                .append(ByteUtils.int2HexWithPush(this.payType, 4))
                .append(ByteUtils.a_text(this.cloudTradeNo));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.tradeType = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.cloud = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.afterBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.afterGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.giveMoneyTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.level = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.specialType = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.discount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.payWay = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        this.payType = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.cloudTradeNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        return innerContent;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal cloud() {
        return Objects.nonNull(this.cloud) ? this.cloud : BigDecimal.ZERO;
    }

    public BigDecimal amount() {
        return Objects.nonNull(this.amount) ? this.amount : this.cash().add(this.cloud());
    }

    public BigDecimal beforeBalance() {
        return Objects.nonNull(this.beforeBalance) ? this.beforeBalance : BigDecimal.ZERO;
    }

    public BigDecimal afterBalance() {
        return Objects.nonNull(this.afterBalance) ? this.afterBalance : BigDecimal.ZERO;
    }

    public BigDecimal beforeGiveMoney() {
        return Objects.nonNull(this.beforeGiveMoney) ? this.beforeGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal afterGiveMoney() {
        return Objects.nonNull(this.afterGiveMoney) ? this.afterGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal discount() {
        return Objects.nonNull(this.discount) ? this.discount : BigDecimal.ZERO;
    }

    /**
     * @description: 总储值余额
     **/
    public BigDecimal getBeforeTotalBalance() {
        return this.beforeBalance().add(this.beforeGiveMoney());
    }

    /**
     * @description: 总储值余额
     **/
    public BigDecimal getAfterTotalBalance() {
        return this.afterBalance().add(this.afterGiveMoney());
    }

    /**
     * @description: 是否赠送永久有效
     **/
    public boolean isGiveForever() {
        return Objects.nonNull(this.afterGiveMoney) && BigDecimalUtils.compareMoreZeroValue(this.afterGiveMoney)
                && (Objects.isNull(this.giveMoneyTime) || DateUtils.TIME_2000_1_1_0_0_0 == this.giveMoneyTime.getTime());
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public Date getExpire() {
        return expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public int getTradeType() {
        return tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCloud() {
        return cloud;
    }

    public void setCloud(BigDecimal cloud) {
        this.cloud = cloud;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getBeforeBalance() {
        return beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getAfterBalance() {
        return afterBalance;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public BigDecimal getBeforeGiveMoney() {
        return beforeGiveMoney;
    }

    public void setBeforeGiveMoney(BigDecimal beforeGiveMoney) {
        this.beforeGiveMoney = beforeGiveMoney;
    }

    public BigDecimal getAfterGiveMoney() {
        return afterGiveMoney;
    }

    public void setAfterGiveMoney(BigDecimal afterGiveMoney) {
        this.afterGiveMoney = afterGiveMoney;
    }

    public Date getGiveMoneyTime() {
        return giveMoneyTime;
    }

    public void setGiveMoneyTime(Date giveMoneyTime) {
        this.giveMoneyTime = giveMoneyTime;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getSpecialType() {
        return specialType;
    }

    public void setSpecialType(String specialType) {
        this.specialType = specialType;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public int getPayWay() {
        return payWay;
    }

    public void setPayWay(int payWay) {
        this.payWay = payWay;
    }

    public int getPayType() {
        return payType;
    }

    public void setPayType(int payType) {
        this.payType = payType;
    }

    public String getCloudTradeNo() {
        return cloudTradeNo;
    }

    public void setCloudTradeNo(String cloudTradeNo) {
        this.cloudTradeNo = cloudTradeNo;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
