package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYPaymentRequest
 * @description
 * @create 2024/1/25 12:15
 */
public class JKYRefundRequest extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. FID 4字节
    private int fid;

    // 3. 退款日志Sid（不传默认订单Sid）
    private int sid;

    // 4. 操作人员
    private int scaleMan;

    // 5. 储值金额退款金额 特殊浮点
    private BigDecimal stored;

    // 6. 现金退款金额 特殊浮点
    private BigDecimal cash;

    // 6. 积分退款 特殊浮点
    private BigDecimal integral;

    // 7. 退货日志的设备编号
    private int balanceId;

    // 8. FID 4字节 Fid 订单编号不能同时为空
    private int originalOrderFid;

    // 9. 原单号
    private String originalOrderNo;

    // 10. 原单时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date originalOrderTime;

    // 11. 随机字节 2字节
    private int random = RandomUtils.integer_random(65535);

    // 12. 标题 退款累计中，第一个商品的商品名
    private String title;

    // 13. 明细数量 1字节
    private int count;

    // 14. 重发序号 1字节
    private int retryCount;

    // 15. 退货备注
    private String remark;

    // 16 自动生成退货日志 0-非自动 1-自动
    private int autoLog;

    public JKYRefundRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYRefundRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.fid(this.fid))
                .append(ByteUtils.fid(this.sid))
                .append(ByteUtils.int2Hex(this.scaleMan))
                .append(ByteUtils.toSPFStrNone(this.stored))
                .append(ByteUtils.toSPFStrNone(this.cash))
                .append(ByteUtils.toSPFStrNone(this.integral))
                .append(ByteUtils.fid(this.balanceId))
                .append(ByteUtils.fid(this.originalOrderFid))
                .append(ByteUtils.a_text(this.originalOrderNo))
                .append(ByteUtils.timeToStrNone(this.originalOrderTime))
                .append(ByteUtils.int2HexWithPush(this.random, 4))
                .append(ByteUtils.a_text(this.title))
                .append(ByteUtils.int2Hex(this.count))
                .append(ByteUtils.int2Hex(this.retryCount))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.int2Hex(this.autoLog));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.sid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.scaleMan = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.stored = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.balanceId = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.originalOrderFid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.originalOrderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.originalOrderTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.title = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.count = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.autoLog = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public BigDecimal stored() {
        return Objects.nonNull(this.stored) ? this.stored : BigDecimal.ZERO;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getSid() {
        return sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getScaleMan() {
        return scaleMan;
    }

    public void setScaleMan(int scaleMan) {
        this.scaleMan = scaleMan;
    }

    public BigDecimal getStored() {
        return stored;
    }

    public void setStored(BigDecimal stored) {
        this.stored = stored;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getIntegral() {
        return integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public int getBalanceId() {
        return balanceId;
    }

    public void setBalanceId(int balanceId) {
        this.balanceId = balanceId;
    }

    public int getOriginalOrderFid() {
        return originalOrderFid;
    }

    public void setOriginalOrderFid(int originalOrderFid) {
        this.originalOrderFid = originalOrderFid;
    }

    public String getOriginalOrderNo() {
        return originalOrderNo;
    }

    public void setOriginalOrderNo(String originalOrderNo) {
        this.originalOrderNo = originalOrderNo;
    }

    public Date getOriginalOrderTime() {
        return originalOrderTime;
    }

    public void setOriginalOrderTime(Date originalOrderTime) {
        this.originalOrderTime = originalOrderTime;
    }

    public int getRandom() {
        return random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getAutoLog() {
        return autoLog;
    }

    public void setAutoLog(int autoLog) {
        this.autoLog = autoLog;
    }
}
