package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYLoginResponse
 * @description
 * @create 2024/1/25 12:16
 */
public class JKYRefundResponse extends AggregatedEntity {

    // 1. 登陆锁定ID A-小程序条码登陆-小程序付款码|B-实体卡内部ID登陆-内部实体卡ID|C-手机号登陆-手机号|D-手机号登陆-手机号
    private String lockId;

    // 2. com.jhscale.common.model.device.polymerization.em.ChannelStatus
    private int code;

    // 3. FID 4字节
    private int fid;

    // 4. 系统订单号
    private String orderNo;

    // 4. 系统退款单号
    private String refundNo;

    // 5. 完成时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expire;

    // 6. 错误码
    private String errCode;

    // 7. 错误描述
    private String errMsg;

    // 8. 交易类型
    private int tradeType;

    // 9. 订单备注信息
    private String remark;

    // 10. 吉卡云退款金额(储值+赠送)
    private BigDecimal stored;

    // 11. 其他方式退款金额
    private BigDecimal other;

    // 12. 实际总退款 金额(stored+amount)
    private BigDecimal actual;

    // 13. 储值退款金额(储值)
    private BigDecimal balance;

    // 14. 赠送退款金额
    private BigDecimal giveMoney;

    // 15. 退款抵扣积分
    private BigDecimal integral;

    // 16. 储值前置金额
    private BigDecimal beforeMoney;

    // 17. 赠送前置金额
    private BigDecimal beforeGiveMoney;

    // 18. 剩余前置积分
    private BigDecimal beforeIntegral;

    // 19. 储值剩余金额
    private BigDecimal surplusMoney;

    // 20. 赠送剩余金额
    private BigDecimal surplusGiveMoney;

    // 21. 剩余积分
    private BigDecimal surplusIntegral;

    // 22. 支付渠道
    private int payWay;

    // 23. 第三方退款单号
    private String cloudRefundNo;

    public JKYRefundResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYRefundResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.lockId))
                .append(ByteUtils.int2Hex(this.code))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.a_text(this.orderNo))
                .append(ByteUtils.a_text(this.refundNo))
                .append(ByteUtils.timeToStrNone(this.expire))
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg))
                .append(ByteUtils.int2Hex(this.tradeType))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.toSPFStrNone(this.stored))
                .append(ByteUtils.toSPFStrNone(this.other))
                .append(ByteUtils.toSPFStrNone(this.actual))
                .append(ByteUtils.toSPFStrNone(this.balance))
                .append(ByteUtils.toSPFStrNone(this.giveMoney))
                .append(ByteUtils.toSPFStrNone(this.integral))
                .append(ByteUtils.toSPFStrNone(this.beforeMoney))
                .append(ByteUtils.toSPFStrNone(this.beforeGiveMoney))
                .append(ByteUtils.toSPFStrNone(this.beforeIntegral))
                .append(ByteUtils.toSPFStrNone(this.surplusMoney))
                .append(ByteUtils.toSPFStrNone(this.surplusGiveMoney))
                .append(ByteUtils.toSPFStrNone(this.surplusIntegral))
                .append(ByteUtils.int2HexWithPush(this.payWay, 4))
                .append(ByteUtils.a_text(this.cloudRefundNo));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.refundNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.tradeType = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.stored = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.other = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.actual = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.balance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.giveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.beforeIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.surplusMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.surplusGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.surplusIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.payWay = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.cloudRefundNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }

    public String getLockId() {
        return lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public Date getExpire() {
        return expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public int getTradeType() {
        return tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getStored() {
        return stored;
    }

    public void setStored(BigDecimal stored) {
        this.stored = stored;
    }

    public BigDecimal getOther() {
        return other;
    }

    public void setOther(BigDecimal other) {
        this.other = other;
    }

    public BigDecimal getActual() {
        return actual;
    }

    public void setActual(BigDecimal actual) {
        this.actual = actual;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getGiveMoney() {
        return giveMoney;
    }

    public void setGiveMoney(BigDecimal giveMoney) {
        this.giveMoney = giveMoney;
    }

    public BigDecimal getIntegral() {
        return integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public BigDecimal getBeforeMoney() {
        return beforeMoney;
    }

    public void setBeforeMoney(BigDecimal beforeMoney) {
        this.beforeMoney = beforeMoney;
    }

    public BigDecimal getBeforeGiveMoney() {
        return beforeGiveMoney;
    }

    public void setBeforeGiveMoney(BigDecimal beforeGiveMoney) {
        this.beforeGiveMoney = beforeGiveMoney;
    }

    public BigDecimal getBeforeIntegral() {
        return beforeIntegral;
    }

    public void setBeforeIntegral(BigDecimal beforeIntegral) {
        this.beforeIntegral = beforeIntegral;
    }

    public BigDecimal getSurplusMoney() {
        return surplusMoney;
    }

    public void setSurplusMoney(BigDecimal surplusMoney) {
        this.surplusMoney = surplusMoney;
    }

    public BigDecimal getSurplusGiveMoney() {
        return surplusGiveMoney;
    }

    public void setSurplusGiveMoney(BigDecimal surplusGiveMoney) {
        this.surplusGiveMoney = surplusGiveMoney;
    }

    public BigDecimal getSurplusIntegral() {
        return surplusIntegral;
    }

    public void setSurplusIntegral(BigDecimal surplusIntegral) {
        this.surplusIntegral = surplusIntegral;
    }

    public int getPayWay() {
        return payWay;
    }

    public void setPayWay(int payWay) {
        this.payWay = payWay;
    }

    public String getCloudRefundNo() {
        return cloudRefundNo;
    }

    public void setCloudRefundNo(String cloudRefundNo) {
        this.cloudRefundNo = cloudRefundNo;
    }
}
