package com.jhscale.common.model.device.polymerization.rely;

import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title DLOGUploadRequest
 * @description
 * @create 2024/3/2 14:09
 */
public class DLOGUploadRequest extends AggregatedEntity {

    private List<DLOGContent> contents;

    public DLOGUploadRequest() {
        super(new AggregatedMark(true, true));
    }

    public DLOGUploadRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder();
        if (this.contents != null && !this.contents.isEmpty()) {
            builder.append(ByteUtils.int2HexWithPush(this.contents.size(), 4));
            for (DLOGContent content : contents) {
                builder.append(ByteUtils.int2Hex(content.getEdition()))
                        .append(ByteUtils.int2HexWithPush(content.getFid(), 8))
                        .append(ByteUtils.int2HexWithPush(content.getSid(), 8))
                        .append(ByteUtils.int2HexWithPush(content.getLogType(), 4))
                        .append(ByteUtils.timeToStrNone(new Date(content.getTradeDate())));
                int length = (StringUtils.isNotBlank(content.getLog()) ? content.getLog().length() : 0) / 2;
                if (length > 0) {
                    builder.append(ByteUtils.int2HexWithPush(length, 4))
                            .append(content.getLog());
                } else {
                    builder.append(ByteUtils.int2HexWithPush(0, 4));
                }
            }
        } else {
            builder.append(ByteUtils.int2HexWithPush(0, 4));
        }
        return builder;
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int size = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        if (size != 0) {
            for (int i = 0; i < size; i++) {
                DLOGContent content = new DLOGContent();

                content.setEdition(ByteUtils.hex2Ten(innerContent.substring(0, 2)));
                innerContent = innerContent.substring(2);

                content.setFid(ByteUtils.hex2Ten(innerContent.substring(0, 8)));
                innerContent = innerContent.substring(8);

                content.setSid(ByteUtils.hex2Ten(innerContent.substring(0, 8)));
                innerContent = innerContent.substring(8);

                content.setLogType(ByteUtils.hex2Ten(innerContent.substring(0, 4)));
                innerContent = innerContent.substring(8);

                Date tradeDate = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
                tradeDate = Objects.nonNull(tradeDate) ? tradeDate : new Date();
                content.setTradeDate(tradeDate.getTime());
                innerContent = innerContent.substring(8);

                int length = ByteUtils.hex2Ten(innerContent.substring(0, 4)) * 2;
                content.setLog(innerContent.substring(4, 4 + length));
                innerContent = innerContent.substring(4 + length);

                this.add(content);
            }
        }
        return innerContent;
    }

    public DLOGUploadRequest add(DLOGContent... contents) {
        if (contents != null && contents.length > 0) {
            if (this.contents == null) this.contents = new ArrayList<>();
            this.contents.addAll(Arrays.asList(contents));
        }
        return this;
    }

    public List<DLOGContent> getContents() {
        return contents;
    }

    public void setContents(List<DLOGContent> contents) {
        this.contents = contents;
    }
}
