
package com.jhscale.common.model.device.polymerization.rely;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title DLOGUploadRequest
 * @description
 * @create 2024/3/2 14:09
 */
public class DLOGUploadResponse extends AggregatedEntity {

    // 1. 结果码 1成功 其余失败 1字节
    private int code;

    // 1. 上传数量 2字节
    private int size;

    public DLOGUploadResponse() {
        super(new AggregatedMark(true, false));
    }

    public DLOGUploadResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2Hex(this.code))
                .append(ByteUtils.int2HexWithPush(this.size, 4));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.size = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        return innerContent;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}
