package com.jhscale.common.model.device.salejob;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.model.device.DData;

import java.math.BigDecimal;
import java.util.List;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DScaleMan
 * @projectName common
 * @description: 营业员职称
 * @date 2022/10/823:16
 */
@DataClass(mark = SAJ)
public class DSaleJobV1<T extends DSaleJobV1> extends DData<T> implements DSaleJob<T> {

    // @ApiModelProperty(value = "营业员职称名称", name = "name")
    @PublicField(index = 2, type = TXT)
    private String name;

    // @ApiModelProperty(value = "职称描述", name = "description")
    @PublicField(index = 3, type = TXT)
    private String description;

    // @ApiModelProperty(value = "营业员权限编号(不传默认全权限)", name = "powers")
    @PublicField(index = 4, type = LST, list_type = INT)
    private List<Integer> disPowers;

    // @ApiModelProperty(value = "底薪", name = "basic")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 5, type = BDL)
    private BigDecimal basic;

    // @ApiModelProperty(value = "提成比例", name = "ratio")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 6, type = BDL)
    private BigDecimal ratio;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(SAJ))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append_text(this.getDescription()))
                .append(this.to_append_list(this.getDisPowers()))
                .append(this.to_append_bigDecimal(this.getBasic()))
                .append(this.to_append_bigDecimal(this.getRatio()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setName(this.toText(all_fields, 1))
                .setDescription(this.toText(all_fields, 2))
                .setDisPowers(this.toIntegerList(all_fields, 3))
                .setBasic(this.toBigDecimal(all_fields, 4))
                .setRatio(this.toBigDecimal(all_fields, 5));
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public String getDescription() {
        return description;
    }

    public T setDescription(String description) {
        this.description = description;
        return (T) this;
    }

    public List<Integer> getDisPowers() {
        return disPowers;
    }

    public T setDisPowers(List<Integer> disPowers) {
        this.disPowers = disPowers;
        return (T) this;
    }

    public BigDecimal getBasic() {
        return basic;
    }

    public T setBasic(BigDecimal basic) {
        this.basic = basic;
        return (T) this;
    }

    public BigDecimal getRatio() {
        return ratio;
    }

    public T setRatio(BigDecimal ratio) {
        this.ratio = ratio;
        return (T) this;
    }
}
