package com.jhscale.common.model.device.saleman;

import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.DDataUtils;

import java.util.List;

/**
 * @author lie_w
 * @title: DScaleMan
 * @projectName common
 * @description: 营业员
 * @date 2022/10/823:16
 */
public interface DSaleMan<T extends DSaleMan> extends DataJSONModel<T> {

    /**
     * @param serial
     * @description: 默认方法1
     */
    @Override
    default String package_method(int serial) {
        String part = "";
        try {
            switch (serial) {
                case 0:
                    part = this.to_append_disPower().toString();
                    break;
            }
        } catch (Exception e) {
        }
        return part;
    }

    /**
     * @param contents
     * @param serial
     * @description: 默认拆解方法1
     */
    @Override
    default PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        try {
            switch (serial) {
                case 0:
                    unPackage = this.contents_copyOfRange(contents, 1);
                    List<Integer> powers = this.toDisPowers(((PublicUnPackageArray) unPackage).getContents(), 0);
                    this.setDisPowers(powers);
                    break;
            }
        } catch (Exception e) {
        }
        return unPackage;
    }

    /**
     * @description: disPowers 转 disPower值
     **/
    default Long to_append_disPower() {
        return DDataUtils.disPowersToDisPower(this.getDisPowers());
    }

    default List<Integer> toDisPowers(String[] all_fields, int index) {
        return DDataUtils.disPowerToDisPowers(toString(all_fields, index));
    }

    /**
     * @description: 获取营业员名称
     **/
    String getName();

    /**
     * @description: 添加权限
     **/
    T setDisPowers(List<Integer> disPowers);

    /**
     * @description: 获取服务配置权限
     **/
    List<Integer> getDisPowers();

    // /**
    //  * @description: 获取条码秤权限值
    //  **/
    // Integer getPower();

    // /**
    //  * @description: 设置条码秤权限能力
    //  **/
    // T setPower(Integer power);


    /**
     * @description: 检查是否拥有权限
     **/
    default boolean hasPower(int power) {
        List<Integer> powers = this.getDisPowers();
        return powers == null || !powers.contains(power);
    }
}
