package com.jhscale.common.model.device.saleman;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.model.device.DData;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DScaleMan
 * @projectName common
 * @description: 营业员
 * @date 2022/10/823:16
 */
@DataClass(mark = SAL)
public class DSaleManV1<T extends DSaleManV1> extends DData<T> implements DSaleMan<T> {

    // @ApiModelProperty(value = "营业员名称", name = "name")
    @PublicField(index = 2, type = TXT)
    private String name;

    // @ApiModelProperty(value = "营业员密码", name = "password")
    @PublicField(index = 3, type = TXT_M1)
    private String password;

    // @ApiModelProperty(value = "变价上限%", name = "changeUpper")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 4, type = BDL)
    private BigDecimal changeUpper;

    // @ApiModelProperty(value = "变价下限%", name = "changeLower")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 5, type = BDL)
    private BigDecimal changeLower;

    // @ApiModelProperty(value = "营业员权限卡号", name = "disPower")
    @PublicField(index = 6, type = M0)
    private Integer disPower;

    // @ApiModelProperty(value = "营业员权限卡号", name = "card")
    @PublicField(index = 7, type = TXT_M1)
    private String card;

    // @ApiModelProperty(value = "营业员禁用权限编号(不传默认全权限)", name = "powers")
    @PublicField(index = 8, type = LST, list_type = INT)
    private List<Integer> disPowers;

    // @ApiModelProperty(value = "职称编号", name = "job")
    @PublicField(index = 9, type = INT, defaultVal = "0")
    private Integer job;

    public Integer job() {
        return Objects.nonNull(this.job) ? this.job : ZERO;
    }

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(SAL))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append(this.getPassword()))
                .append(this.to_append_bigDecimal(this.getChangeUpper()))
                .append(this.to_append_bigDecimal(this.getChangeLower()))
                .append(this.to_append(this.to_append_disPower()))
                .append(this.to_append(this.getCard()))
                .append(this.to_append_list(this.getDisPowers()))
                .append(this.to_append(this.job()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        List<Integer> disPower = this.toDisPowers(all_fields, 5);
        List<Integer> disPowers = this.toIntegerList(all_fields, 7);
        this.setNo(this.toInteger(all_fields, 0))
                .setName(this.toText(all_fields, 1))
                .setPassword(this.toString(all_fields, 2))
                .setChangeUpper(this.toBigDecimal(all_fields, 3))
                .setChangeLower(this.toBigDecimal(all_fields, 4))
                .setCard(this.toString(all_fields, 6))
                .setDisPowers(Objects.nonNull(disPowers) && !disPowers.isEmpty() ? disPowers : disPower)
                .setJob(this.toInteger(all_fields, 8));
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public String getPassword() {
        return password;
    }

    public T setPassword(String password) {
        this.password = password;
        return (T) this;
    }

    public BigDecimal getChangeUpper() {
        return changeUpper;
    }

    public T setChangeUpper(BigDecimal changeUpper) {
        this.changeUpper = changeUpper;
        return (T) this;
    }

    public BigDecimal getChangeLower() {
        return changeLower;
    }

    public T setChangeLower(BigDecimal changeLower) {
        this.changeLower = changeLower;
        return (T) this;
    }

    public String getCard() {
        return card;
    }

    public T setCard(String card) {
        this.card = card;
        return (T) this;
    }

    public List<Integer> getDisPowers() {
        return disPowers;
    }

    public T setDisPowers(List<Integer> disPowers) {
        this.disPowers = disPowers;
        return (T) this;
    }

    public T addDisPowers(Integer... powers) {
        if (powers != null && powers.length > 0) {
            if (this.disPowers == null) this.disPowers = new ArrayList<>();
            this.disPowers.addAll(Arrays.asList(powers));
        }
        return (T) this;
    }

    public Integer getJob() {
        return job;
    }

    public T setJob(Integer job) {
        this.job = job;
        return (T) this;
    }
}
