package com.jhscale.common.model.device.shortkey;

import com.jhscale.common.em.BarcodeScale;
import com.jhscale.common.model.inter.DataJSONModel;

/**
 * @author lie_w
 * @title: DScaleMan
 * @projectName common
 * @description: 营业员
 * @date 2022/10/823:16
 */
public interface DShortKey<T extends DShortKey> extends DataJSONModel<T> {

    /**
     * @description: 添加 快捷键 排序序号
     **/
    default T addOrder(Integer board, Integer order, Integer plu) {
        BarcodeScale barcodeScale = BarcodeScale.ftBoard(board);
        int[] page_index = barcodeScale.order2PageIndex(order);
        return (T) this.setBoard(barcodeScale.getBoard())
                .setPage(page_index[0])
                .setIndex(page_index[1])
                .setPlu(plu);
    }

    /**
     * @description: 获取 快捷键 排序序号
     **/
    default int obtainOrder(Integer board) {
        return BarcodeScale.ftBoard(board).pageIndex2Order(this.getPage(), this.getIndex());
    }

    /**
     * @description: 获取 快捷键 排序序号
     **/
    default int obtainOrder() {
        return this.obtainOrder(this.getBoard());
    }

    /**
     * @description: 设置面板
     **/
    T setBoard(Integer board);

    /**
     * @description: 获取面板编号
     **/
    Integer getBoard();

    /**
     * @description: 获取页
     **/
    Integer getPage();

    /**
     * @description: 设置页面
     **/
    T setPage(Integer page);

    /**
     * @description: 获取坐标
     **/
    Integer getIndex();

    /**
     * @description: 设置坐标
     **/
    T setIndex(Integer index);

    /**
     * @description: 添加商品编号
     **/
    T setPlu(Integer plu);
}
