package com.jhscale.common.model.device.shortkey;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.em.BarcodeScale;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DShortKeyV1
 * @projectName common
 * @description: 快捷键
 * @date 2022/10/1017:02
 */
@DataClass(mark = SCP)
public class DShortKeyV1<T extends DShortKeyV1> implements DShortKey<T> {

    // @ApiModelProperty(value = "页码", name = "page")
    @PublicField(index = 1, type = INT)
    private Integer page;

    // @ApiModelProperty(value = "坐标", name = "index")
    @PublicField(index = 2, type = INT)
    private Integer index;

    // @ApiModelProperty(value = "PLU编号", name = "plu")
    @PublicField(index = 3, type = INT)
    private Integer plu;

    // @ApiModelProperty(value = "编号", name = "no")
    @PublicField(index = 4, type = INT, defaultVal = "0")
    private Integer no;

    // @ApiModelProperty(value = "快捷键名称", name = "name")
    @PublicField(index = 5, type = TXT, defaultVal = DEFAULT_SHORT_NAME)
    private String name;

    // @ApiModelProperty(value = "快捷键面板类型", name = "board")
    @PublicField(index = 6, type = INT, defaultVal = "1")
    private Integer board;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        // 前置数据处理
        this.prepose();
        return new StringBuilder()
                .append(this.to_append(SCP))
                .append(this.to_append(this.getPage()))
                .append(this.to_append(this.getIndex()))
                .append(this.to_append(this.getPlu()))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append(this.getBoard()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setPage(this.toInteger(all_fields, 0))
                .setIndex(this.toInteger(all_fields, 1))
                .setPlu(this.toInteger(all_fields, 2))
                .setNo(this.toInteger(all_fields, 3))
                .setName(this.toText(all_fields, 4, DEFAULT_SHORT_NAME))
                .setBoard(this.toInteger(all_fields, 5));
        return (T) this;
    }

    public Integer getPage() {
        return page;
    }

    public T setPage(Integer page) {
        this.page = page;
        return (T) this;
    }

    public Integer getIndex() {
        return index;
    }

    public T setIndex(Integer index) {
        this.index = index;
        return (T) this;
    }

    public Integer getPlu() {
        return plu;
    }

    public T setPlu(Integer plu) {
        this.plu = plu;
        return (T) this;
    }

    public Integer getNo() {
        return no;
    }

    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.no;
    }

    public T setNo(Integer no) {
        this.no = no;
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public Integer getBoard() {
        return board;
    }

    public T setBoard(Integer board) {
        this.board = BarcodeScale.board(board).getBoard();
        return (T) this;
    }
}
