package com.jhscale.common.model.device.shortpage;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;

import java.util.List;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DShortPageV1
 * @projectName common
 * @description: TODO
 * @date 2022/10/1017:06
 */
@DataClass(mark = SCG)
public class DShortPageV1<T extends DShortPageV1> extends DData<T> implements DShortPage<T> {

    // @ApiModelProperty(value = "快捷页名称", name = "name")
    @PublicField(index = 2, type = TXT)
    private String name;

    // @ApiModelProperty(value = "PLU编号", name = "pluNos")
    @PublicField(index = 3, type = LST, list_type = INT)
    private List<Integer> pluNos;

    // @ApiModelProperty(value = "排列序号", name = "serial")
    // @PublicField(index = 4, type = INT)
    // private Integer serial;

    // @ApiModelProperty(value = "显示隐藏 0-隐藏 1-显示(默认)", name = "hidden")
    // @PublicField(index = 4, type = INT, defaultVal = "1")
    // private Integer hidden;


    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(SCG))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append_list(this.getPluNos()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setName(this.toText(all_fields, 1))
                .setPluNos(this.toIntegerList(all_fields, 2));
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public List<Integer> getPluNos() {
        return pluNos;
    }

    public T setPluNos(List<Integer> pluNos) {
        this.pluNos = pluNos;
        return (T) this;
    }

    // public Integer getSerial() {
    //     return serial;
    // }

    // public T setSerial(Integer serial) {
    //     this.serial = serial;
    //     return (T) this;
    // }

    // public Integer getHidden() {
    //     return hidden;
    // }

    // public T setHidden(Integer hidden) {
    //     this.hidden = hidden;
    //     return (T) this;
    // }
}
