package com.jhscale.common.model.device.shortpage_formwork;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;

import java.util.List;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DShortPageV1
 * @projectName common
 * @description: 快捷页模板
 * @date 2022/10/1017:06
 */
@DataClass(mark = SGF)
public class DShortPageFormworkV1<T extends DShortPageFormworkV1> extends DData<T> implements DShortPageFormwork<T> {

    // @ApiModelProperty(value = "快捷页名称", name = "name")
    @PublicField(index = 2, type = TXT)
    private String name;

    // @ApiModelProperty(value = "快捷页编号列表", name = "shortPages")
    @PublicField(index = 3, type = LST, list_type = INT)
    private List<Integer> shortPages;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(SGF))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append_list(this.getShortPages()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setName(this.toText(all_fields, 1))
                .setShortPages(this.toIntegerList(all_fields, 2));
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public List<Integer> getShortPages() {
        return shortPages;
    }

    public T setShortPages(List<Integer> shortPages) {
        this.shortPages = shortPages;
        return (T) this;
    }
}
