package com.jhscale.common.model.device.text_parameter;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DTextParameter
 * @projectName common
 * @description: 文本参数
 * @date 2022/12/3013:47
 */
@DataClass(mark = TMT, ignorePublicField = DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST)
public class DTextParameterV1<T extends DTextParameterV1> extends DData<T> implements DTextParameter<T> {

    // @ApiModelProperty(value = "文本参数内容值", name = "value")
    @PublicField(index = 2, type = TXT)
    private String value;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(TMT))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getValue()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setValue(this.toText(all_fields, 1));
        return (T) this;
    }

    public String getValue() {
        return value;
    }

    public T setValue(String value) {
        this.value = value;
        return (T) this;
    }
}
