package com.jhscale.common.model.file;

import com.jhscale.common.em.Project;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.Objects;

import static com.jhscale.common.content.JHContents.*;

/**
 * @author lie_w
 * @title: UploadFile
 * @projectName common
 * @description: TODO
 * @date 2023/2/159:22
 */
public class FileName implements GJSONModel {

    @ApiModelProperty(value = "时间", name = "date")
    private Date date;

    @ApiModelProperty(value = "身份标识", name = "account")
    private String account;

    @ApiModelProperty(value = "功能点", name = "fuc")
    private String fuc;

    @ApiModelProperty(value = "文件名", name = "name", required = true)
    private String name;

    @ApiModelProperty(value = "文件类型", name = "type")
    private String type;

    /**
     * @description: 共有 默认文件名
     **/
    public String public_fileName() {
        return this.fileName(true, true);
    }

    public String public_dir() {
        return this.fileName(true, false);
    }

    /**
     * @description: 服务器 文件名
     * 需要按照时间保存，添加 date 参数;
     * 不需要按照时间保存的;
     **/
    public String server_fileName() {
        return this.fileName(false, true);
    }

    public String server_dir() {
        return this.fileName(false, false);
    }

    /**
     * @description: 添加项目名称
     **/
    public FileName project(Project project) {
        this.fuc = Objects.nonNull(project) ? project.getOssPath() : "";
        return this;
    }

    /**
     * @description: 添加名称
     **/
    public FileName addName(String... name_parts) {
        if (name_parts != null && name_parts.length > 0) {
            if (this.name == null) this.name = "";
            for (String part : name_parts) {
                this.name += OSS_Separator + part;
            }
        }
        return this;
    }

    /**
     * @description: 默认文件名
     **/
    public String fileName(boolean defaultDate, boolean defaultName) {
        StringBuilder builder = new StringBuilder();
        Date date = Objects.nonNull(this.date) ? this.date : (defaultDate ? new Date() : null);
        if (Objects.nonNull(date)) {
            String date_yymmdd = DateUtils.getDate_YYMMDD(date);
            builder.append(OSS_Separator).append(date_yymmdd);
        }

        if (StringUtils.isNotBlank(this.account)) {
            builder.append(OSS_Separator).append(this.account);
        }

        if (StringUtils.isNotBlank(this.fuc)) {
            builder.append(OSS_Separator).append(this.fuc);
        }

        String type = (StringUtils.isBlank(this.type) || this.type.startsWith(File_Type_Split)) ? this.type : (File_Type_Split + this.type);

        while (StringUtils.isNotBlank(this.name) && this.name.startsWith(OSS_Separator)) {
            this.name = this.name.substring(1);
        }

        if (StringUtils.isNotBlank(this.name)) {
            if (this.name.contains(File_Type_Split)) {
                builder.append(OSS_Separator).append(this.name);
            } else if (StringUtils.isNotBlank(type)) {
                builder.append(OSS_Separator).append(this.name).append(type);
            }
        } else if (StringUtils.isNotBlank(type)) {
            builder.append(OSS_Separator).append(System.currentTimeMillis()).append(type);
        } else if (defaultName) {
            builder.append(OSS_Separator).append(System.currentTimeMillis()).append(UN_KNOW_FILE_TYPE);
        }

        String fileName = builder.toString();
        while (StringUtils.isNotBlank(fileName) && fileName.startsWith(OSS_Separator)) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    public Date getDate() {
        return date;
    }

    public FileName setDate(Date date) {
        this.date = date;
        return this;
    }

    public String getAccount() {
        return account;
    }

    public FileName setAccount(String account) {
        this.account = account;
        return this;
    }

    public String getFuc() {
        return fuc;
    }

    public FileName setFuc(String fuc) {
        this.fuc = fuc;
        return this;
    }

    public String getName() {
        return name;
    }

    public FileName setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return type;
    }

    public FileName setType(String type) {
        this.type = type;
        return this;
    }
}
