package com.jhscale.common.model.http;

import com.jhscale.common.em.DeviceType;
import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: DeviceHead
 * @projectName common
 * @description: TODO
 * @date 2020-12-039:18
 */
@ApiModel("设备头信息")
public class DeviceHead extends JSONModel {

    @ApiModelProperty(value = "设备类型", name = "type", hidden = true)
    private DeviceType type;

    @ApiModelProperty(value = "设备唯一识别码", name = "unique", hidden = true)
    private String unique;

    @ApiModelProperty(value = "设备名称", name = "name", hidden = true)
    private String name;

    @ApiModelProperty(value = "商户业务标识", name = "usign", hidden = true)
    private Long usign;

    @ApiModelProperty(value = "商户店铺标识", name = "ssign", hidden = true)
    private Long ssign;

    public DeviceHead() {
    }

    public DeviceHead(DeviceType type, String unique) {
        this.type = type;
        this.unique = unique;
    }

    public DeviceHead(DeviceType type, String unique, Long usign) {
        this.type = type;
        this.unique = unique;
        this.usign = usign;
    }

    public DeviceHead(DeviceType type, String unique, Long usign, Long ssign) {
        this.type = type;
        this.unique = unique;
        this.usign = usign;
        this.ssign = ssign;
    }

    public DeviceType getType() {
        return type;
    }

    public DeviceHead setType(DeviceType type) {
        this.type = type;
        return this;
    }

    public String getUnique() {
        return unique;
    }

    public DeviceHead setUnique(String unique) {
        this.unique = unique;
        return this;
    }

    public String getName() {
        return name;
    }

    public DeviceHead setName(String name) {
        this.name = name;
        return this;
    }

    public Long getUsign() {
        return usign;
    }

    public DeviceHead setUsign(Long usign) {
        this.usign = usign;
        return this;
    }

    public Long getSsign() {
        return ssign;
    }

    public DeviceHead setSsign(Long ssign) {
        this.ssign = ssign;
        return this;
    }

    /**
     * @description: Redis Key
     **/
    public String redisKey() {
        return type.getSign() + ":" + this.getUnique();
    }

    /**
     * @description: 检查设备头信息
     **/
    public boolean checkDeviceHead() {
        return Objects.nonNull(this.type) && StringUtils.isNotBlank(this.unique);
    }

    /**
     * @description: 检查无归属设备头信息
     **/
    public boolean checkNoAttributionDeviceHead() {
        return this.checkDeviceHead() && Objects.nonNull(this.usign) && Objects.nonNull(this.ssign);
    }
}
