package com.jhscale.common.model.http;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.internatonal.International;
import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: HttpResponse
 * @projectName common
 * @description: TODO
 * @date 2020-12-0219:22
 */
@ApiModel("HTTP响应数据")
public class HttpResponse extends JSONModel {

    @ApiModelProperty(value = "通讯状态码", name = "return_code", hidden = true)
    private String return_code;

    @ApiModelProperty(value = "异常信息", name = "return_msg", hidden = true)
    private International return_msg;

    @ApiModelProperty(value = "业务状态码", name = "result_code", hidden = true)
    private String result_code;

    @ApiModelProperty(value = "业务异常信息", name = "result_Msg", hidden = true)
    private International result_msg;

    @ApiModelProperty(value = "retrun_code 和 result_code 同时为 SUCCESS 是返回业务数据", name = "response", hidden = true)
    private Object response;

    public HttpResponse() {
    }

    public HttpResponse(String return_code, International return_msg, String result_code, International result_msg, Object response) {
        this.return_code = return_code;
        this.return_msg = return_msg;
        this.result_code = result_code;
        this.result_msg = result_msg;
        this.response = response;
    }

    /**
     * @description: 通讯首次发生业务数据异常
     **/
    public static HttpResponse linkFail(International international) {
        return new HttpResponse(JHContents.FAIL, international, null, null, null);
    }

    /**
     * @description: 业务异常
     **/
    public static HttpResponse businessFail(International international) {
        return new HttpResponse(JHContents.SUCCESS, null, JHContents.FAIL, international, null);
    }

    /**
     * @description: 业务成功
     **/
    public static HttpResponse success(Object response) {
        return new HttpResponse(JHContents.SUCCESS, null, JHContents.SUCCESS, null, response);
    }

    public String getReturn_code() {
        return return_code;
    }

    public void setReturn_code(String return_code) {
        this.return_code = return_code;
    }

    public International getReturn_msg() {
        return return_msg;
    }

    public void setReturn_msg(International return_msg) {
        this.return_msg = return_msg;
    }

    public String getResult_code() {
        return result_code;
    }

    public void setResult_code(String result_code) {
        this.result_code = result_code;
    }

    public International getResult_msg() {
        return result_msg;
    }

    public void setResult_msg(International result_msg) {
        this.result_msg = result_msg;
    }

    public Object getResponse() {
        return response;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public boolean return_code() {
        return JHContents.SUCCESS.equals(this.return_code);
    }

    public boolean result_code() {
        return JHContents.SUCCESS.equals(this.result_code);
    }

    public boolean result() {
        return this.return_code() && this.result_code();
    }
}
