package com.jhscale.common.model.http;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: JResponse
 * @projectName common
 * @description: 响应对象
 * @date 2020-10-2317:11
 */
@ApiModel("基础响应对象")
public class JResponse extends JSONModel implements Signature {

    // 接口版本 [必填] 默认1.0
    @ApiModelProperty(value = "版本号[必填]", name = "version", example = "1.0", hidden = true)
    private String version;

    // 随机字符串 [必填]
    @ApiModelProperty(value = "随机字符串[必填]", name = "nonce_str", hidden = true)
    private String nonce_str;

    // 请求时间 [必填] 时间秒数 UNINX 时间数 保证请求有效性
    @ApiModelProperty(value = "UNINX请求时间 [必填]", name = "timestamp", hidden = true)
    private Long timestamp;

    // 签名 [必填] 用于签名验证
    @ApiModelProperty(value = "签名 [必填]", name = "sign", hidden = true)
    private String sign;

    // 签名类型 [非必填] 默认MD5
    @ApiModelProperty(value = "签名类型 [必填] 默认MD5", name = "sign_type", hidden = true)
    private String sign_type;

    // 时区 [非必填] 默认8时区
    @ApiModelProperty(value = "时区 [非必填] 默认8", name = "time_zone", hidden = true)
    private String time_zone;

    /**
     * @description: 响应构建签名
     **/
    @Override
    public String bulidSign(String key, String... ingronal) {
        this.defaultInit();
        return this.bulidSign(key, ingronal);
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getNonce_str() {
        return nonce_str;
    }

    @Override
    public void setNonce_str(String nonce_str) {
        this.nonce_str = nonce_str;
    }

    @Override
    public Long getTimestamp() {
        return timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getSign() {
        return sign;
    }

    @Override
    public void setSign(String sign) {
        this.sign = sign;
    }

    @Override
    public String getSign_type() {
        return sign_type;
    }

    @Override
    public void setSign_type(String sign_type) {
        this.sign_type = sign_type;
    }

    @Override
    public String getTime_zone() {
        return time_zone;
    }

    @Override
    public void setTime_zone(String time_zone) {
        this.time_zone = time_zone;
    }
}
