package com.jhscale.common.model.http;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;

/**
 * @author lie_w
 * @title: LocalLogRequest
 * @projectName common
 * @description: 本地日志请求
 * @date 2022/8/129:31
 */
public class LocalLogRequest extends JRequest {

    private Equiment equiment;

    private Message message;

    private Port port;

    private Map other;

    @ApiModel("设备信息")
    public static class Equiment extends JSONModel {

        @ApiModelProperty(value = "app_name(version)", name = "app")
        private String app;

        @ApiModelProperty(value = "机型(版本)", name = "device")
        private String device;

        @ApiModelProperty(value = "本机IP", name = "ip")
        private String ip;

        @ApiModelProperty(value = "用户帐号(用户标识)", name = "sign")
        private String sign;

        public String getApp() {
            return app;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public String getDevice() {
            return device;
        }

        public void setDevice(String device) {
            this.device = device;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getSign() {
            return sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }
    }

    @ApiModel("异常信息")
    private static class Message extends JSONModel {

        @ApiModelProperty(value = "错误码(JSL_ | CODE)", name = "code")
        private String code;

        @ApiModelProperty(value = "info|debug|warning|error", name = "level", required = true)
        private String level;

        @ApiModelProperty(value = "错误信息", name = "msg")
        private String msg;

        @ApiModelProperty(value = "原始堆栈", name = "throwable")
        private String throwable;

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getLevel() {
            return level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getThrowable() {
            return throwable;
        }

        public void setThrowable(String throwable) {
            this.throwable = throwable;
        }
    }

    @ApiModel("路径参数")
    private static class Port extends JSONModel {

        @ApiModelProperty(value = "请求参数", name = "request")
        private String request;

        @ApiModelProperty(value = "响应参数", name = "response")
        private String response;

        @ApiModelProperty(value = "耗时", name = "time")
        private Long time;

        @ApiModelProperty(value = "local|server", name = "type")
        private String type;

        @ApiModelProperty(value = "local == routing || type == server", name = "url")
        private String url;

        public String getRequest() {
            return request;
        }

        public void setRequest(String request) {
            this.request = request;
        }

        public String getResponse() {
            return response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public Long getTime() {
            return time;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public Equiment getEquiment() {
        return equiment;
    }

    public void setEquiment(Equiment equiment) {
        this.equiment = equiment;
    }

    public Message getMessage() {
        return message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Port getPort() {
        return port;
    }

    public void setPort(Port port) {
        this.port = port;
    }

    public Map getOther() {
        return other;
    }

    public void setOther(Map other) {
        this.other = other;
    }
}
