
package com.jhscale.common.model.http;

import com.jhscale.common.model.simple.JSONModel;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title WSAccept
 * @description
 * @create 2024/4/11 13:16
 */
public class WSEntity extends JSONModel {

    // 类型
    private String type;

    // 通讯设备唯一标识
    private String key;

    // 通讯戳
    private String nonce = String.valueOf(System.currentTimeMillis() / 1000);

    public WSEntity() {
    }

    public WSEntity(String type, String key) {
        this.type = type;
        this.key = key;
    }

    public WSEntity(String type, String key, String nonce) {
        this(type, key);
        this.nonce = nonce;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getNonce() {
        return nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }
}
