package com.jhscale.common.model.inter;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.Default;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.ServerField;
import com.jhscale.common.em.Version;
import com.jhscale.common.model.device.DBContent;
import com.jhscale.common.model.device._inner.*;
import com.jhscale.common.model.device.plu.param.Prepose;
import com.jhscale.common.model.simple.FieldModel;
import com.jhscale.common.utils.*;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: JSONModel
 * @projectName common
 * @description: TODO
 * @date 2020-11-1416:15
 */
public interface DataJSONModel<T extends DataJSONModel> extends GJSONModel {

    /**
     * @description: 编号
     **/
    default Integer no() {
        return 0;
    }

    /**
     * @description: 添加编号
     **/
    default void sno(Integer no) {
    }

    default DBContent toDBContent() {
        return null;
    }

    /**
     * @description: 序列初始化
     **/
    @Deprecated
    default T serialInit() {
        Map<String, Field> fieldMap = this.allAndroidField();
        if (fieldMap != null && !fieldMap.isEmpty()) {
            fieldMap.forEach((k, f) -> {
                Default annotation = f.getAnnotation(Default.class);
                if (annotation != null) {
                    String defaultVal = annotation.value();
                    try {
                        f.setAccessible(true);
                        Object value = f.get(this);
                        if (value != null) {
                            if (StringUtils.isNotBlank(defaultVal)) {
                                if ((value instanceof Integer && value.equals(Integer.parseInt(defaultVal))) ||
                                        (value instanceof String && value.equals(defaultVal)) ||
                                        (value instanceof BigDecimal && BigDecimalUtils.compareEqual((BigDecimal) value, new BigDecimal(defaultVal))) ||
                                        (value instanceof Long && value.equals(Long.parseLong(defaultVal)))) {
                                    f.set(this, null);
                                }
                            } else if (value instanceof DataJSONModel) {
                                ((DataJSONModel) value).serialInit();
                            } else if (value instanceof List) {
                                ((List) value).forEach(lv -> {
                                    if (lv != null && lv instanceof DataJSONModel) ((DataJSONModel) lv).serialInit();
                                });
                            } else if (value instanceof Map) {
                                ((Map) value).forEach((mk, mv) -> {
                                    if (mv != null && mv instanceof DataJSONModel) ((DataJSONModel) mv).serialInit();
                                });
                            }
                        }
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return (T) this;
    }

    /**
     * @description: 字符高压
     **/
    @Deprecated
    default String gzip() {
        return GZIPUtils.compress(this.toJSON());
    }

    /**
     * @description: init 后 ZIP
     **/
    @Deprecated
    default String init_gzip() {
        return GZIPUtils.compress(this.serialInit().toJSON());
    }

    /**
     * @description: 字符高压解析
     **/
    @Deprecated
    default T ungzip(String content, Class<T> clazz) {
        return GJSONUtils.jsonToObject(content, clazz);
    }

    /**
     * @description: 内容组装
     **/
    @Deprecated
    default String assemble() {
        return this.assemble(true);
    }

    /**
     * @description: 内容组装
     **/
    @Deprecated
    default String assemble(boolean zip) {
        Map<String, Field> fieldMap = this.allAndroidField();
        List<String> keys = this.sortMapKey(fieldMap);
        if (keys != null && !keys.isEmpty()) {
            String content = this.assemble(fieldMap, keys);
            return zip ? Base64Utils.gzipString(content) : content;
        }
        return "";
    }

    /**
     * @description: 字段内容组装
     **/
    @Deprecated
    default String assemble(Map<String, Field> fieldMap, List<String> keys) {
        StringBuffer buffer = new StringBuffer();
        keys.forEach(key -> {
            try {
                Field field = fieldMap.get(key);
                field.setAccessible(true);
                Object obj = field.get(this);
                buffer.append(this.innerObject(obj))
                        .append(FIELD_SPLIT);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        return buffer.length() > 0 ? buffer.substring(0, buffer.length() - 1) : buffer.toString();
    }

    /**
     * @description: List 格式内容拼装
     **/
    default StringBuffer innerObject(Object obj) {
        StringBuffer buffer = new StringBuffer();
        if (Objects.nonNull(obj)) {
            if (obj instanceof FieldModel) {
                buffer.append(((FieldModel) obj).assembleFieldVal());
            } else if (obj instanceof String
                    || obj instanceof Integer
                    || obj instanceof Long
                    || obj instanceof BigDecimal
                    || obj instanceof Double
                    || obj instanceof Boolean) {
                buffer.append(obj.toString());
            } else if (obj instanceof List) {
                buffer.append(LIST_SPLIT_START);
                ((List) obj).forEach(o -> {
                    buffer.append(o instanceof FieldModel ? this.innerObject(o) : (o instanceof String ? o.toString() : GJSONUtils.objectToJSON(o)))
                            .append(LIST_SPLIT);
                });
                buffer.append(LIST_SPLIT_END);
            } else if (obj instanceof Map) {
                buffer.append(LIST_SPLIT_START);
                ((Map) obj).forEach((k, v) -> {
                    buffer.append(k)
                            .append(MAP_KEY)
                            .append(v instanceof FieldModel ? this.innerObject(v) : (v instanceof String ? v.toString() : GJSONUtils.objectToJSON(v)))
                            .append(LIST_SPLIT);
                });
                buffer.append(LIST_SPLIT_END);
            } else {
                buffer.append(GJSONUtils.objectToJSON(obj));
            }
        } else {
            buffer.append(SPACE);
        }
        return buffer;
    }

    /**
     * @description: 内容解析
     **/
    @Deprecated
    default T parse(String data) {
        return this.parse(data, true);
    }

    /**
     * @description: 内容解析
     **/
    @Deprecated
    default T parse(String data, boolean zip) {
        if (StringUtils.isNotBlank(data)) {
            data = zip ? Base64Utils.ungzipString(data) : data;
            String[] fieldSplits = data.split(FIELD_SPLIT);

            if (fieldSplits != null && fieldSplits.length > 0) {
                Map<String, Field> fieldMap = this.allAndroidField();
                List<String> keys = this.sortMapKey(fieldMap);

                for (int i = 0; i < fieldSplits.length; i++) {
                    if (i >= keys.size()) break;
                    String fieldSplit = fieldSplits[i];
                    if (StringUtils.isNotBlank(fieldSplit)) {
                        this.addField(this, fieldMap.get(keys.get(i)), fieldSplit);
                    }
                }
            }
        }
        return (T) this;
    }

    /**
     * @description: 对象字段添加值
     **/
    @Deprecated
    default void addField(Object obj, Field field, String fieldStr) {
        try {
            field.setAccessible(true);
            if (field.getType().equals(Integer.class)) {
                field.set(obj, Integer.parseInt(fieldStr));
            } else if (field.getType().equals(Double.class)) {
                field.set(obj, Double.parseDouble(fieldStr));
            } else if (field.getType().equals(Boolean.class)) {
                field.set(obj, Boolean.parseBoolean(fieldStr));
            } else if (field.getType().equals(Long.class)) {
                field.set(obj, Long.parseLong(fieldStr));
            } else if (field.getType().equals(BigDecimal.class)) {
                field.set(obj, new BigDecimal(fieldStr));
            } else if (field.getType().equals(String.class)) {
                field.set(obj, fieldStr);
            } else if (field.getType().equals(List.class) || field.getType().equals(Map.class)) {
                fieldStr = fieldStr.trim();
                if (fieldStr.startsWith(LIST_SPLIT_START) && fieldStr.endsWith(LIST_SPLIT_END))
                    fieldStr = fieldStr.substring(1, fieldStr.length() - 1);

                List<String> listPart = Arrays.asList(fieldStr.split(LIST_SPLIT));
                Type genericType = field.getGenericType();

                field.set(obj, field.getType().equals(List.class) ? this.toList(listPart, genericType) : this.toMap(listPart, genericType));
            } else {
                field.set(obj, ((FieldModel) field.getType().newInstance()).parseFieldVal(fieldStr));
            }
        } catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 转Map
     **/
    @Deprecated
    default Map toMap(List<String> listPart, Type genericType) {
        Class keyClazz = null, valClazz = null, innerValClazz = null;
        boolean valClazzIsList = false;

        if (genericType instanceof ParameterizedType) {
            keyClazz = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];

            Type valType = ((ParameterizedType) genericType).getActualTypeArguments()[1];
            if (valType instanceof ParameterizedType) {
                Type[] innerValType = ((ParameterizedType) valType).getActualTypeArguments();
                valClazzIsList = true;
                innerValClazz = (Class<?>) innerValType[0];
            } else {
                valClazz = (Class<?>) valType;
            }
        }

        Map map = new HashMap();

        Class finalKeyClazz = keyClazz;
        Class finalValClazz = valClazz;
        Class finalInnerValClazz = innerValClazz;
        boolean finalValClazzIsList = valClazzIsList;
        Optional.ofNullable(listPart)
                .orElse(Collections.emptyList())
                .stream().forEach(kv -> {
                    try {
                        String[] kvArray = kv.split(MAP_KEY);
                        Object val = null;
                        if (kvArray.length == 2) {
                            if (finalValClazzIsList) {
                                val = GJSONUtils.jsonToList(kvArray[1], finalInnerValClazz);
                            } else {
                                val = finalValClazz.newInstance();
                                if (val instanceof FieldModel) {
                                    val = ((FieldModel) finalValClazz.newInstance()).parseFieldVal(kvArray[1]);
                                } else if (val instanceof Double) {
                                    val = Double.parseDouble(kvArray[1]);
                                } else if (val instanceof Boolean) {
                                    val = Boolean.parseBoolean(kvArray[1]);
                                } else if (val instanceof Long) {
                                    val = Long.parseLong(kvArray[1]);
                                } else if (val instanceof Integer) {
                                    val = Integer.parseInt(kvArray[1]);
                                } else if (val instanceof BigDecimal) {
                                    val = new BigDecimal(kvArray[1]);
                                } else if (GJSONUtils.isJSON(kvArray[1])) {
                                    val = GJSONUtils.gsonToMaps(kvArray[1]);
                                } else {
                                    val = kvArray[1];
                                }
                            }
                        }
                        map.put(this.val(kvArray[0], finalKeyClazz), val);
                    } catch (InstantiationException | IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });
        return map;
    }

    /**
     * @description: 字段转List
     **/
    default List toList(List<String> listPart, Type genericType) {
        Class innerClazz = null;
        if (genericType instanceof ParameterizedType)
            innerClazz = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];

        Class finalInnerClazz = innerClazz;
        return Optional.ofNullable(listPart)
                .orElse(Collections.emptyList())
                .stream().map(part -> {
                    try {
                        Object obj = finalInnerClazz.newInstance();
                        if (obj instanceof FieldModel) {
                            return ((FieldModel) obj).parseFieldVal(part);
                        } else if (obj instanceof String) {
                            return part;
                        } else {
                            return GJSONUtils.jsonToObject(part, finalInnerClazz);
                        }
                    } catch (InstantiationException | IllegalAccessException e) {
                        e.printStackTrace();
                        return part;
                    }
                }).collect(Collectors.toList());
    }

    /**
     * @description: 字符串转换成对应类型
     **/
    default <T> T val(String val, Class<T> type) {
        // 把val转换成type类型返回 比如说getVal("123",Integer.class) 返回一个123
        T value = null;
        try {
            Constructor<T> constructor = type.getConstructor(String.class);
            constructor.setAccessible(true);
            value = constructor.newInstance(val);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    /**
     * @description: 服务器 字段获取
     **/
    default List<Field> Server_Fields() {
        Map<String, Field> fieldMap = this.allAndroidField();
        List<Field> fields = new ArrayList<>();
        for (Field field : fieldMap.values()) {
            ServerField annotation = field.getAnnotation(ServerField.class);
            if (annotation != null) {
                fields.add(field);
            }
        }

        Collections.sort(fields, new Comparator<Field>() {
            @Override
            public int compare(Field o1, Field o2) {
                ServerField oa1 = o1.getAnnotation(ServerField.class);
                ServerField oa2 = o2.getAnnotation(ServerField.class);
                return oa1.index() - oa2.index();
            }
        });
        return fields;
    }

    /**
     * @description: 服务器 必填 字段获取
     **/
    default List<Field> Server_Fields_Must() {
        Map<String, Field> fieldMap = this.allAndroidField();
        List<Field> fields = new ArrayList<>();
        for (Field field : fieldMap.values()) {
            ServerField annotation = field.getAnnotation(ServerField.class);
            if (annotation != null && annotation.must()) {
                fields.add(field);
            }
        }

        Collections.sort(fields, new Comparator<Field>() {
            @Override
            public int compare(Field o1, Field o2) {
                ServerField oa1 = o1.getAnnotation(ServerField.class);
                ServerField oa2 = o2.getAnnotation(ServerField.class);
                return oa1.index() - oa2.index();
            }
        });
        return fields;
    }

    /**
     * @description: 服务器 非必填 字段获取
     **/
    default List<Field> Server_Fields_Not_Must() {
        Map<String, Field> fieldMap = this.allAndroidField();
        List<Field> fields = new ArrayList<>();
        for (Field field : fieldMap.values()) {
            ServerField annotation = field.getAnnotation(ServerField.class);
            if (annotation != null && !annotation.must()) {
                fields.add(field);
            }
        }

        Collections.sort(fields, new Comparator<Field>() {
            @Override
            public int compare(Field o1, Field o2) {
                ServerField oa1 = o1.getAnnotation(ServerField.class);
                ServerField oa2 = o2.getAnnotation(ServerField.class);
                return oa1.index() - oa2.index();
            }
        });
        return fields;
    }

    /**
     * @description: Server 打包所有字段
     **/
    default String Server_Package_All_Field(Version version) {
        // 全部字段组包
        StringBuilder builder = new StringBuilder();
        for (Field field : this.Server_Fields()) {
            builder.append(this.Server_Field_Package(field, version));
        }
        return builder.toString();
    }

    /**
     * @description: Server 浮动打包
     **/
    default String Server_Package() {
        return Server_Package(Version.VERSION04);
    }

    /**
     * @description: Server 浮动打包
     **/
    default String Server_Package(Version version) {
        StringBuilder builder = new StringBuilder();

        // 必填字段组包
        for (Field field : this.Server_Fields_Must()) {
            builder.append(this.Server_Field_Package(field, version));
        }

        // 非必填字段
        List<Field> fields = this.Server_Fields_Not_Must();
        if (fields != null && !fields.isEmpty()) {
            // 浮动字段内容
            List<String> not_must_list = new ArrayList<>();
            for (int i = 0; i < fields.size(); i++) {
                not_must_list.add(i, this.Server_Field_Package(fields.get(i), version));
            }

            // 浮动字段数值计算
            String float_package = this.Float_Package(not_must_list);
            // System.out.println(String.format("Server_Float_Package：%s - %s", this.getClass().getSimpleName(), float_package));
            builder.append(float_package);

            // 浮动字段组包
            for (String not_must : not_must_list) {
                if (StringUtils.isNotBlank(not_must)) {
                    builder.append(not_must);
                }
            }
        }
        return builder.toString();
    }

    /**
     * @description: 字段打包 默认转义
     **/
    default String Server_Field_Package(Field field, Version version) {
        return this.Server_Field_Package(field, true, version);
    }

    /**
     * @description: 字段打包
     **/
    default String Server_Field_Package(Field field, boolean convert, Version version) {
        ServerField annotation = field.getAnnotation(ServerField.class);
        if (annotation != null) {
            try {
                field.setAccessible(true);
                String server_field_content_package = this.Server_Field_Content_Package(annotation.type(), annotation.length(), annotation.must(), annotation.field_class(),
                        field.get(this),
                        convert,
                        annotation.list_type(), annotation.list_class(),
                        annotation.map_key_type(), annotation.map_key_class(), annotation.map_val_type(), annotation.map_val_class(),
                        version);
                // System.out.println(String.format("Server_Field_Package %s - %s - %s",
                // this.getClass().getSimpleName(), field.getName(), server_field_content_package));
                return server_field_content_package;
            } catch (IllegalAccessException e) {
                System.err.printf("Server_Field_Package %s - %s - %s%n",
                        this.getClass().getSimpleName(), field.getName(), e.getMessage());
                e.printStackTrace();
            }
        }
        return "";
    }

    /**
     * @param type          数据类型
     * @param length        数据定义长度
     * @param must          必填字段
     * @param clazz         字段类型
     * @param val           数据值
     * @param convert       数据是否转移
     * @param list_type     list 数据类型
     * @param list_clazz    list 数据类型 class
     * @param map_key_type  map key 数据类型
     * @param map_key_clazz map key 数据类型 class
     * @param map_val_type  map value 数据类型
     * @param map_val_clazz map value 数据类型 class
     * @description: Server 字段内容打包
     **/
    default String Server_Field_Content_Package(int type, int length, boolean must, Class clazz,
                                                Object val,
                                                boolean convert,
                                                int list_type, Class list_clazz,
                                                int map_key_type, Class map_key_clazz, int map_val_type, Class map_val_clazz,
                                                Version version) {
        StringBuffer part = new StringBuffer();
        switch (type) {
            case LST:
                if (val != null) {
                    List list = (List) val;
                    part.append(this.append_convert(Integer.toHexString(list.size()), 4, convert));
                    list.forEach(oval -> {
                        String list_part = this.Server_Field_Content_Package(list_type, -1, false, list_clazz, oval, convert, version);
                        if (StringUtils.isNotBlank(list_part)) {
                            part.append(this.append_convert(Integer.toHexString(list_part.length() / 2), 8, convert))
                                    .append(list_part);
                        }
                    });
                } else if (must) {
                    part.append(this.append_convert(Integer.toHexString(0), 4, convert));
                }
                break;
            case MAP:
                if (val != null) {
                    Map map = (Map) val;
                    part.append(this.append_convert(Integer.toHexString(map.size()), 4, convert));
                    map.forEach((k, v) -> {
                        String key_part = this.Server_Field_Content_Package(map_key_type, -1, false, map_key_clazz, k, convert, version);
                        if (StringUtils.isNotBlank(key_part)) {
                            String val_part = this.Server_Field_Content_Package(map_val_type, -1, false, map_val_clazz, v, convert, version);
                            part.append(this.append_convert(Integer.toHexString(key_part.length() / 2), 8, convert))
                                    .append(key_part)
                                    .append(this.append_convert(Integer.toHexString(val_part.length() / 2), 8, convert))
                                    .append(val_part);
                        }
                    });
                } else if (must) {
                    part.append(this.append_convert(Integer.toHexString(0), 4, convert));
                }
                break;
            default:
                part.append(this.Server_Field_Content_Package(type, length, must, clazz, val, convert, version));
                break;
        }
        return part.toString();
    }

    /**
     * @param type    数据类型
     * @param length  数据定义长度
     * @param clazz   字段类型
     * @param val     数据值
     * @param convert 数据是否转移
     * @description: Server 字段内容打包 基本字段
     **/
    default String Server_Field_Content_Package(int type, int length, boolean must, Class clazz,
                                                Object val,
                                                boolean convert, Version version) {
        String part = "";
        switch (type) {
            case INT:
                Integer i = val != null ? ((Integer) val) : (must ? 0 : null);
                if (i != null) part = this.append_convert(Integer.toHexString(i), length, convert);
                break;
            case LNG:
                Long l = val != null ? ((Long) val) : (must ? 0 : null);
                if (l != null) part = this.append_convert(Long.toHexString(l), length, convert);
                break;
            case LNT:
                Long lt = val != null ? ((Long) val) : (must ? DateUtils.getDefaultTime().getTime() : null);
                if (lt != null) part = this.append_convert(ByteUtils.timeToStr(lt), convert);
                break;
            case TME:
                Date time = val != null ? ((Date) val) : (must ? DateUtils.getDefaultTime() : null);
                if (time != null) part = this.append_convert(ByteUtils.timeToStrNoConvert((Date) val), convert);
                break;
            case BDL:
                BigDecimal db = val != null ? ((BigDecimal) val) : (must ? BigDecimal.ZERO : null);
                if (db != null) {
                    switch (version) {
                        case VERSION02:
                        case VERSION03:
                            part = this.append_convert(ByteUtils.bigDecimalToStr((BigDecimal) val), convert);
                            break;
                        case VERSION04:
                            part = this.append_convert(ByteUtils.bigDecimalToStr2((BigDecimal) val), convert);
                            break;
                        default:
                            part = this.append_convert(ByteUtils.bigDecimalToStr2((BigDecimal) val), convert);
                            break;
                    }
                }
                // if (StringUtils.isNotBlank(part)) System.out.println("bigDecimalToStr " + part);
                break;
            case FML:
                try {
                    FieldModel fm = val != null ? ((FieldModel) val) : (must ? (FieldModel) clazz.newInstance() : null);
                    if (fm != null) part = ((FieldModel) val).Server_Package(version);
                } catch (Exception e) {
                }
                break;
            case TXT:
                String text = val != null ? ((String) val) : (must ? "" : null);
                if (text != null) {
                    if (version == null) {
                        part = this.append(ByteUtils.txtToStr_UTF8((String) val)) + TXT_END;
                    } else {
                        switch (version) {
                            case VERSION02:
                                part = this.append(ByteUtils.txtToStr((String) val)) + TXT_END;
                                break;
                            case VERSION03:
                                part = this.append(ByteUtils.txtToStr_UTF8((String) val)) + TXT_END;
                                break;
                            default:
                                part = this.append(ByteUtils.txtToStr_UTF8((String) val)) + TXT_END;
                                break;
                        }
                    }
                }
                break;
        }
        return part;
    }

    /**
     * @description: Server 拆包所有字段
     **/
    default String Server_UnPackage_All_Field(String content, Version version) {
        // 全部字段拆包
        for (Field field : this.Server_Fields()) {
            this.Server_Field_UnPackage(field, content, version);
        }
        return content;
    }

    /**
     * @description: Server 浮动拆包
     **/
    default ServerUnPackageObject Server_UnPackage(String content) {
        return this.Server_UnPackage(content, Version.VERSION04);
    }

    /**
     * @description: Server 浮动拆包
     **/
    default ServerUnPackageObject Server_UnPackage(String content, Version version) {
        ServerUnPackage unPackage = new ServerUnPackage(content);
        // 必填字段拆包
        for (Field field : this.Server_Fields_Must()) {
            unPackage = this.Server_Field_UnPackage(field, unPackage.getSurplusContent(), version);
        }

        // 非必填字段
        List<Field> fields = this.Server_Fields_Not_Must();
        if (fields != null && !fields.isEmpty()) {
            unPackage = this.Float_UnPackage(unPackage.getSurplusContent());
            // System.out.println(String.format("Server_Float_UnPackage：%s - %s", this.getClass().getSimpleName(), ((ServerUnPackageFloat) unPackage).getIndex()));
            if (!((ServerUnPackageFloat) unPackage).getIndex().isEmpty()) {
                for (Integer index : ((ServerUnPackageFloat) unPackage).getIndex()) {
                    unPackage = this.Server_Field_UnPackage(fields.get(index), unPackage.getSurplusContent(), version);
                }
            }
        }
        return new ServerUnPackageObject(unPackage.getSurplusContent(), this);
    }

    /**
     * @description: 字段拆包 默认转义
     **/
    default ServerUnPackageObject Server_Field_UnPackage(Field field, String content, Version version) {
        return this.Server_Field_UnPackage(field, content, true, version);
    }

    /**
     * @description: 字段拆包
     **/
    default ServerUnPackageObject Server_Field_UnPackage(Field field, String content, boolean convert, Version version) {
        ServerField annotation = field.getAnnotation(ServerField.class);
        if (annotation != null && StringUtils.isNotBlank(content)) {
            ServerUnPackageObject unPackageObject = this.Server_UnPackage(content,
                    annotation.type(), annotation.length(), annotation.field_class(),
                    convert,
                    annotation.list_type(), annotation.list_class(),
                    annotation.map_key_type(), annotation.map_key_class(), annotation.map_val_type(), annotation.map_val_class(),
                    version);
            if (unPackageObject.getObj() != null) {
                try {
                    field.setAccessible(true);
                    // System.out.println(String.format("Server_Field_UnPackage %s - %s - %s",
                    //         this.getClass().getSimpleName(), field.getName(), JSONUtils.objectToJSON(unPackageObject.getObj())));
                    field.set(this, unPackageObject.getObj());
                } catch (IllegalAccessException e) {
                    System.err.println(String.format("Server_Field_UnPackage %s - %s - %s",
                            this.getClass().getSimpleName(), field.getName(), e.getMessage()));
                    e.printStackTrace();
                }
                return new ServerUnPackageObject(unPackageObject.getSurplusContent(), this);
            }
        }
        return new ServerUnPackageObject(content, this);
    }

    /**
     * @param content       待拆解数据包
     * @param type          数据类型
     * @param length        数据定义长度
     * @param clazz         FieldModel 数据类型 class
     * @param convert       数据是否转移
     * @param list_type     list 数据类型
     * @param list_clazz    list 数据类型 class
     * @param map_key_type  map key 数据类型
     * @param map_key_clazz map key 数据类型 class
     * @param map_val_type  map value 数据类型
     * @param map_val_clazz map value 数据类型 class
     * @description: 字段内容拆包
     **/
    default ServerUnPackageObject Server_UnPackage(String content,
                                                   int type, int length, Class clazz,
                                                   boolean convert,
                                                   int list_type, Class list_clazz,
                                                   int map_key_type, Class map_key_clazz, int map_val_type, Class map_val_clazz,
                                                   Version version) {
        Object result = null;
        ServerUnPackage unPackage = new ServerUnPackage(content);
        if (StringUtils.isNotBlank(content)) {
            try {
                switch (type) {
                    case LST:
                        result = new ArrayList<>();
                        unPackage = this.content_substring_convert(content, 4, convert);
                        if (StringUtils.isBlank(((ServerUnPackageSubstring) unPackage).getSubString())) break;
                        int list_size = Integer.parseInt(((ServerUnPackageSubstring) unPackage).getSubString(), 16);
                        for (int i = 0; i < list_size; i++) {
                            unPackage = this.content_substring_convert(unPackage.getSurplusContent(), 8, convert);
                            if (StringUtils.isBlank(((ServerUnPackageSubstring) unPackage).getSubString())) break;
                            int oval_length = Integer.parseInt(((ServerUnPackageSubstring) unPackage).getSubString(), 16) * 2;
                            unPackage = this.content_substring(unPackage.getSurplusContent(), oval_length);
                            ServerUnPackageObject list_unPackageObject = this.Server_UnPackage(
                                    ((ServerUnPackageSubstring) unPackage).getSubString(),
                                    list_type, oval_length, list_clazz, convert, version);
                            if (list_unPackageObject.getObj() != null)
                                ((ArrayList) result).add(list_unPackageObject.getObj());
                        }
                        break;
                    case MAP:
                        result = new HashMap<>();
                        unPackage = this.content_substring_convert(content, 4, convert);
                        if (StringUtils.isBlank(((ServerUnPackageSubstring) unPackage).getSubString())) break;
                        int map_size = Integer.parseInt(((ServerUnPackageSubstring) unPackage).getSubString(), 16);
                        for (int i = 0; i < map_size; i++) {
                            unPackage = this.content_substring_convert(unPackage.getSurplusContent(), 8, convert);
                            if (StringUtils.isBlank(((ServerUnPackageSubstring) unPackage).getSubString())) break;
                            int map_key_length = Integer.parseInt(((ServerUnPackageSubstring) unPackage).getSubString(), 16) * 2;
                            unPackage = this.content_substring(unPackage.getSurplusContent(), map_key_length);
                            ServerUnPackageObject map_key_unPackageObject = this.Server_UnPackage(
                                    ((ServerUnPackageSubstring) unPackage).getSubString(),
                                    map_key_type, map_key_length, map_key_clazz, convert, version);
                            if (map_key_unPackageObject.getObj() != null) {
                                unPackage = this.content_substring_convert(unPackage.getSurplusContent(), 8, convert);
                                if (StringUtils.isBlank(((ServerUnPackageSubstring) unPackage).getSubString())) break;
                                int map_val_length = Integer.parseInt(((ServerUnPackageSubstring) unPackage).getSubString(), 16) * 2;
                                unPackage = this.content_substring(unPackage.getSurplusContent(), map_val_length);
                                ServerUnPackageObject map_val_unPackageObject = this.Server_UnPackage(
                                        ((ServerUnPackageSubstring) unPackage).getSubString(),
                                        map_val_type, map_val_length, map_val_clazz, convert, version);
                                ((HashMap) result).put(map_key_unPackageObject.getObj(), map_val_unPackageObject.getObj());
                            }
                        }
                        break;
                    default:
                        unPackage = this.Server_UnPackage(content, type, length, clazz, convert, version);
                        result = ((ServerUnPackageObject) unPackage).getObj();
                        break;
                }
            } catch (Exception e) {
                System.err.printf("UnPackage %s-%s-%s%n", type, content, e.getMessage());
                e.printStackTrace();
            }
        }
        return new ServerUnPackageObject(unPackage.getSurplusContent(), result);
    }

    /**
     * @param content 待拆解数据包
     * @param type    数据类型
     * @param length  数据定义长度
     * @param clazz   FieldModel 数据类型 class
     * @param convert 数据是否转移
     * @description: 字段内容拆包 基本字段
     **/
    default ServerUnPackageObject Server_UnPackage(String content,
                                                   int type, int length, Class clazz,
                                                   boolean convert, Version version) {
        Object result = null;
        ServerUnPackage unPackage = new ServerUnPackage(content);
        if (StringUtils.isNotBlank(content)) {
            try {
                switch (type) {
                    case INT:
                        unPackage = this.content_substring_convert(content, length, convert);
                        result = Integer.parseInt(((ServerUnPackageSubstring) unPackage).getSubString(), 16);
                        break;
                    case LNG:
                        unPackage = this.content_substring_convert(content, length, convert);
                        result = Long.parseLong(((ServerUnPackageSubstring) unPackage).getSubString(), 16);
                        break;
                    case LNT:
                        unPackage = this.content_substring_convert(content, 8, convert);
                        result = ByteUtils.strToTimeMillis(((ServerUnPackageSubstring) unPackage).getSubString());
                        break;
                    case TME:
                        unPackage = this.content_substring_convert(content, 8, convert);
                        result = ByteUtils.strToDate(((ServerUnPackageSubstring) unPackage).getSubString());
                        break;
                    case BDL:
                        switch (version) {
                            case VERSION02:
                            case VERSION03:
                                unPackage = this.content_substring_convert(content, 8, convert);
                                break;
                            case VERSION04:
                                unPackage = this.content_substring_convert(content, 16, convert);
                                break;
                            default:
                                unPackage = this.content_substring_convert(content, 16, convert);
                                break;
                        }
                        // if (StringUtils.isNotBlank(((ServerUnPackageSubstring) unPackage).getSubString()))
                        //     System.out.println("strToBigDecimal " + ((ServerUnPackageSubstring) unPackage).getSubString());
                        result = ByteUtils.strToBigDecimal(((ServerUnPackageSubstring) unPackage).getSubString());
                        break;
                    case FML:
                        unPackage = ((FieldModel) (clazz.newInstance())).Server_UnPackage(content, version);
                        result = ((ServerUnPackageObject) unPackage).getObj();
                        break;
                    case TXT:
                        unPackage = this.content_substring(content, ByteUtils.indexOfWithStr(content, TXT_END));
                        if (version == null) {
                            result = ByteUtils.strToTxt_UTF8(((ServerUnPackageSubstring) unPackage).getSubString());
                        } else {
                            switch (version) {
                                case VERSION02:
                                    result = ByteUtils.strToTxt(((ServerUnPackageSubstring) unPackage).getSubString());
                                    break;
                                case VERSION03:
                                    result = ByteUtils.strToTxt_UTF8(((ServerUnPackageSubstring) unPackage).getSubString());
                                    break;
                                default:
                                    result = ByteUtils.strToTxt_UTF8(((ServerUnPackageSubstring) unPackage).getSubString());
                                    break;
                            }
                        }
                        break;
                }
            } catch (Exception e) {
                System.err.printf("UnPackage %s-%s-%s%n", type, content, e.getMessage());
                e.printStackTrace();
            }
        }
        return new ServerUnPackageObject(unPackage.getSurplusContent(), result);
    }

    /**
     * @description: 填充 转移
     **/
    default String append(String content) {
        return this.append_convert(content, -1, false);
    }

    /**
     * @description: 填充 转移
     **/
    default String append_convert(String content, boolean convert) {
        return this.append_convert(content, -1, convert);
    }

    /**
     * @description: 填充 转移
     **/
    default String append_convert(String content, int length, boolean convert) {
        return this.convert(ByteUtils.appendFill(content, length), convert);
    }

    /**
     * @description: 转移
     **/
    default String convert(String content, boolean convert) {
        if (StringUtils.isBlank(content)) return "";
        return convert
                ?
                ByteUtils.convert(content)
                :
                content;
    }

    /**
     * @description: 填充 转移
     **/
    default String append_convert(String content) {
        return this.append_convert(content, -1, true);
    }

    /**
     * @description: 填充 转移
     **/
    default String append_convert(String content, int length) {
        return this.append_convert(content, length, true);
    }

    /**
     * @description: 内容截取并返回
     **/
    default ServerUnPackageSubstring content_substring(String content, int length) {
        return this.content_substring_convert(content, length, false);
    }

    /**
     * @description: 内容截取并返回
     **/
    default ServerUnPackageSubstring content_substring_convert(String content, int length, boolean convert) {
        length = Math.min(content.length(), length);
        String substring = content.substring(0, length);
        substring = this.convert(substring, convert);
        content = content.substring(length);
        return new ServerUnPackageSubstring(content, substring);
    }

    /**
     * @description: 浮动标志组装
     **/
    default String Float_Package(List<String> not_must_list) {
        int[][] Float = new int[10][8];
        for (int i = 0; i < not_must_list.size(); i++) {
            if (StringUtils.isNotBlank(not_must_list.get(i))) {
                if (i < 7) {
                    Float[0][i] = 1;
                } else {
                    int index = i + 9;
                    Float[index / 8][index % 8] = 1;
                }
            }
        }

        if (ArrayUtils.contains(Float[2], 1))
            Float[1][0] = 1;

        if (ArrayUtils.contains(Float[3], 1))
            Float[1][1] = 1;

        if (ArrayUtils.contains(Float[4], 1))
            Float[1][2] = 1;

        if (ArrayUtils.contains(Float[5], 1))
            Float[1][3] = 1;

        if (ArrayUtils.contains(Float[6], 1))
            Float[1][4] = 1;

        if (ArrayUtils.contains(Float[7], 1))
            Float[1][5] = 1;

        if (ArrayUtils.contains(Float[8], 1))
            Float[1][6] = 1;

        if (ArrayUtils.contains(Float[9], 1))
            Float[1][7] = 1;

        if (ArrayUtils.contains(Float[1], 1))
            Float[0][7] = 1;

        StringBuffer buffer = new StringBuffer();
        for (int[] ints : Float) {
            if (ArrayUtils.contains(ints, 1)) {
                String binary = "";
                for (int anInt : ints) {
                    binary += anInt;
                }
                buffer.append(ByteUtils.binaryToHex(binary));
            }
        }
        return buffer.toString();
    }

    /**
     * @description: 浮动标志拆解
     **/
    default ServerUnPackageFloat Float_UnPackage(String content) {
        List<Integer> index = new ArrayList<>();
        ServerUnPackageSubstring unPackageSubstring = this.content_substring(content, 2);
        char[] chars1 = ByteUtils.hexToBinary(unPackageSubstring.getSubString()).toCharArray();
        boolean line2_has = false;
        for (int i = 0; i < chars1.length; i++) {
            if (i == 7 && chars1[i] == '1') {
                line2_has = true;
                break;
            }
            if (chars1[i] == '1') index.add(i);
        }

        if (line2_has) {
            unPackageSubstring = this.content_substring(unPackageSubstring.getSurplusContent(), 2);
            char[] chars2 = ByteUtils.hexToBinary(unPackageSubstring.getSubString()).toCharArray();
            for (int j = 0; j < chars2.length; j++) {
                if (chars2[j] == '1') {
                    unPackageSubstring = this.content_substring(unPackageSubstring.getSurplusContent(), 2);
                    char[] chars = ByteUtils.hexToBinary(unPackageSubstring.getSubString()).toCharArray();
                    for (int k = 0; k < chars.length; k++) {
                        if (chars[k] == '1') {
                            index.add(7 + (j * 8) + k);
                        }
                    }
                }
            }
        }
        return new ServerUnPackageFloat(unPackageSubstring.getSurplusContent(), index);
    }

    /**
     * @description: 公开协议字段 获取
     **/
    default List<Field> Public_Fields() {
        return DDataUtils.Public_Fields(this.getClass());
    }

    /**
     * @description: 公开协议 组包
     **/
    default String Public_Package() {
        StringBuffer buffer = new StringBuffer();
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        if (annotation != null) {
            buffer.append(this.Public_Package(annotation.separator()));
        }
        return buffer.toString();
    }

    /**
     * @description: 公开协议 组包
     **/
    default String Public_Package(List<Field> fields) {
        StringBuffer buffer = new StringBuffer();
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        if (annotation != null) {
            buffer.append(this.Public_Package(annotation.separator(), fields));
        }
        return buffer.toString();
    }

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    default StringBuilder Public_Package_No_Reflex() {
        // 前置数据处理
        this.prepose();
        return new StringBuilder();
    }

    /**
     * @description: 公开协议 组包
     **/
    default String Public_Package(String separator) {
        return this.Public_Package(separator, this.Public_Fields());
    }

    /**
     * @description: 公开协议 组包
     **/
    default String Public_Package(String separator, List<Field> fields) {
        // 前置数据处理
        this.prepose();

        StringBuffer buffer = new StringBuffer();
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        if (annotation != null) {
            buffer.append(annotation.mark())
                    .append(StringUtils.isNotBlank(annotation.mark()) ? separator : "");

            // 字段填充
            for (int i = 0; i < fields.size(); i++) {
                buffer.append(this.Public_Field_Package(fields.get(i), annotation))
                        .append(i != fields.size() - 1 ? separator : "");
//                        .append(separator);
            }
            buffer.append(StringUtils.isNotBlank(annotation.mark()) ? (separator + annotation.line()) : "");
        }
        return buffer.toString();
    }

    /**
     * @description: 公开协议 Field Array
     **/
    default List<String> Public_Package_Array() {
        List<String> list = new ArrayList<>();
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        if (annotation != null) {
            // 字段填充
            List<Field> fields = this.Public_Fields();
            for (int i = 0; i < fields.size(); i++) {
                list.add(this.Public_Field_Package(fields.get(i), annotation));
            }
        }
        return list;
    }

    /**
     * @description: 字段打包
     **/
    default String Public_Field_Package(Field field, DataClass class_annotation) {
        PublicField field_annotation = field.getAnnotation(PublicField.class);
        if (class_annotation != null && field_annotation != null) {
            try {
                field.setAccessible(true);
                String public_field_content_package = this.Public_Field_Content_Package(class_annotation, field_annotation, field.get(this));
                if (class_annotation.print())
                    System.out.println(String.format("Server_Field_Package %s - %s - %s",
                            this.getClass().getSimpleName(), field.getName(), public_field_content_package));
                return public_field_content_package;
            } catch (IllegalAccessException e) {
                System.err.println(String.format("Field_Package %s - %s - %s",
                        this.getClass().getSimpleName(), field.getName(), e.getMessage()));
                e.printStackTrace();
            }
        }
        return "";
    }

    /**
     * @param class_annotation 类注解
     * @param field_annotation 字段注解
     * @param val              数据值
     * @description: 公开 字段内容打包
     **/
    default String Public_Field_Content_Package(DataClass class_annotation, PublicField field_annotation, Object val) {
        StringBuffer buffer = new StringBuffer();
        switch (field_annotation.type()) {
            case LST1_M1:
                List list_m1 = (List) (val == null ?
                        this.defaultVal(LST, field_annotation.defaultVal(), field_annotation.list_class(), null)
                        : val);
                if (list_m1 != null && !list_m1.isEmpty()) {
                    for (int i = 0; i < list_m1.size(); i++) {
                        List array = ((FieldModel) list_m1.get(i)).Public_Package_Array();

                        buffer.append(class_annotation.line())
                                .append(RES)
                                .append(class_annotation.separator())
                                .append(i + 1)
                                .append(class_annotation.separator());

                        for (int j = 0; j < 7; j++) {
                            buffer.append(array.get(j))
                                    .append(class_annotation.separator());
                        }

                        buffer.append(this.package_method(0))
                                .append(class_annotation.separator());

                        for (int j = 7; j < 13; j++) {
                            buffer.append(array.get(j))
                                    .append(class_annotation.separator());
                        }

                        buffer.append(this.package_method(1))
                                .append(class_annotation.separator());

                        for (int j = 13; j < array.size(); j++) {
                            buffer.append(array.get(j))
                                    .append(j == array.size() - 1 ? "" : class_annotation.separator());
                        }
                    }
                } else {
                    buffer.append(class_annotation.line())
                            .append(RES)
                            .append(class_annotation.separator())
                            .append(0)
                            .append(class_annotation.separator())
                            .append(this.package_method(2));
                }
                buffer.append(class_annotation.line())
                        .append(REE)
                        .append(class_annotation.separator());
                break;
            case LST:
                List list = (List) (val == null ?
                        this.defaultVal(LST, field_annotation.defaultVal(), field_annotation.list_class(), null)
                        : val);
                if (list != null && !list.isEmpty()) {
                    for (int i = 0; i < list.size(); i++) {
                        buffer.append(this.Public_Field_Content_Package(
                                        class_annotation.separator(),
                                        field_annotation.list_type(), "", field_annotation.list_class(),
                                        list.get(i)))
                                .append(i != list.size() - 1 ? field_annotation.set_split() : "");
                    }
                } else {
                    buffer.append("");
                }
                break;
            case MAP:
                Map map = (Map) (val == null ?
                        this.defaultVal(MAP, field_annotation.defaultVal(), field_annotation.map_key_class(), field_annotation.map_val_class())
                        : val);
                if (map != null && !map.isEmpty()) {
                    int count = 0;
                    for (Object key : map.keySet()) {
                        count++;
                        if (Objects.nonNull(key)) {
                            buffer.append(this.Public_Field_Content_Package(class_annotation.separator(),
                                            field_annotation.map_key_type(), "", field_annotation.map_key_class(),
                                            key))
                                    .append(field_annotation.set_kv_split())
                                    .append(this.Public_Field_Content_Package(class_annotation.separator(),
                                            field_annotation.map_val_type(), "", field_annotation.map_val_class(),
                                            map.get(key)))
                                    .append(count < map.size() ? field_annotation.set_split() : "");
                        }
                    }
                } else {
                    buffer.append("");
                }
                break;
            default:
                buffer.append(this.Public_Field_Content_Package(
                        class_annotation.separator(),
                        field_annotation.type(), field_annotation.defaultVal(), field_annotation.field_class(),
                        val));
                break;
        }
        return buffer.toString();
    }

    /**
     * @param separator  字段分隔符
     * @param type       字段类型
     * @param defaultVal 默认值
     * @param clazz      字段类型
     * @param val        数据值
     * @description: 公开 字段内容打包
     **/
    default String Public_Field_Content_Package(String separator,
                                                int type, String defaultVal, Class clazz,
                                                Object val) {
        StringBuffer buffer = new StringBuffer();
        switch (type) {
            case INT:
                Integer i = (Integer) (val == null ? this.defaultVal(defaultVal, Integer.class) : val);
                if (i != null) buffer.append(i);
                break;
            case DOUBLE:
                Double d = (Double) (val == null ? this.defaultVal(defaultVal, Double.class) : val);
                if (d != null) buffer.append(d);
                break;
            case LNG:
                Long l = (Long) (val == null ? this.defaultVal(defaultVal, Long.class) : val);
                if (l != null) buffer.append(l);
                break;
            case LNT:
                Long lt = (Long) (val == null ? this.defaultVal(defaultVal, Long.class) : val);
                if (lt != null) {
                    String time_space = DateUtils.getFormatDate_YYYY_MM_DD_HH_MM_SS_Space(new Date(lt));
                    String[] split = time_space.split(" ");
                    for (int index = 0; index < split.length; index++) {
                        buffer.append(split[index])
                                .append((index != (split.length - 1)) ? separator : "");
                    }
                }
                break;
            case TME:
                Date date = (Date) (val == null ? this.defaultVal(defaultVal, Date.class) : val);
                if (date != null) {
                    String time_space = DateUtils.getFormatDate_YYYY_MM_DD_HH_MM_SS_Space(date);
                    String[] split = time_space.split(" ");
                    for (int index = 0; index < split.length; index++) {
                        buffer.append(split[index])
                                .append((index != (split.length - 1)) ? separator : "");
                    }
                }
                break;
            case TME_M1:
                Date date1 = (Date) (val == null ? this.defaultVal(defaultVal, Date.class) : val);
                if (date1 != null) {
                    String time_space = DateUtils.getFormatDate_YY_MM_DD_HH_MM_SS_Space(date1);
                    String[] split = time_space.split(" ");
                    for (int index = 0; index < split.length; index++) {
                        buffer.append(split[index])
                                .append((index != (split.length - 1)) ? separator : "");
                    }
                }
                break;
            case BDL:
                BigDecimal bigDecimal = (BigDecimal) (val == null ? this.defaultVal(defaultVal, BigDecimal.class) : val);
                if (bigDecimal != null) buffer.append(BigDecimalUtils.bigDecimalToString(bigDecimal));
                break;
            case FML:
                FieldModel fieldModel = (FieldModel) (val == null ? this.defaultVal(defaultVal, clazz) : val);
                if (fieldModel != null) buffer.append(fieldModel.Public_Package());
                break;
            case FML_M1:
                FieldModel fieldModel_M1 = (FieldModel) (val == null ? this.defaultVal(defaultVal, clazz) : val);
                if (fieldModel_M1 != null) buffer.append(fieldModel_M1.Public_Package());
                break;
            case TXT:
                String str = (String) (val == null ? this.defaultVal(defaultVal, String.class) : val);
                if (StringUtils.isNotBlank(str)) buffer.append(ByteUtils.tryParseToString(str));
                break;
            case TXT_M1:
                String str1 = (String) (val == null ? this.defaultVal(defaultVal, String.class) : val);
                if (StringUtils.isNotBlank(str1)) buffer.append(str1);
                break;
            case M0:
                buffer.append(this.package_method(0));
                break;
            case M1:
                buffer.append(this.package_method(1));
                break;
            case M2:
                buffer.append(this.package_method(2));
                break;
            case M3:
                buffer.append(this.package_method(3));
                break;
            case M4:
                buffer.append(this.package_method(4));
                break;
            case M5:
                buffer.append(this.package_method(5));
                break;
            case M6:
                buffer.append(this.package_method(6));
                break;
            case M7:
                buffer.append(this.package_method(7));
                break;
        }
        return buffer.toString();
    }

    /**
     * @description: 对象前置对象处理
     **/
    default Prepose prepose() {
        return new Prepose();
    }

    /**
     * @param serial
     * @description: 默认组装方法1
     */
    default String package_method(int serial) {
        return "";
    }

    /**
     * @description: 默认拆解方法1
     **/
    default PublicUnPackage un_package_method(String[] contents, int serial) {
        return new PublicUnPackage(contents);
    }

    /**
     * @description: 公开协议 拆包
     **/
    default T Public_UnPackage(String content) {
        if (StringUtils.isNotBlank(content)) {
            DataClass annotation = this.getClass().getAnnotation(DataClass.class);
            if (annotation != null) {
                if (content.startsWith(annotation.mark())) content = content.substring(annotation.mark().length() + 1);
                if (content.endsWith(annotation.line()))
                    content = content.substring(0, content.length() - annotation.line().length());
                String[] contents = content.split(annotation.separator());
                if (contents.length > 0) this.Public_UnPackage(contents);
            }
        }
        return (T) this;
    }

    /**
     * @description: 公开协议 拆包
     **/
    default T Public_UnPackage_No_Reflex(String content) {
        if (StringUtils.isNotBlank(content)) {
            String[] all_fields = content.split(PUBLIC_FIELD_SPLIT);
            this.Public_UnPackage_No_Reflex(Arrays.copyOfRange(all_fields, 1, all_fields.length));
        }
        return (T) this;
    }

    /**
     * @description: 公开协议 拆包
     **/
    default T Public_UnPackage_WithOut_SE(String content) {
        if (StringUtils.isNotBlank(content)) {
            DataClass annotation = this.getClass().getAnnotation(DataClass.class);
            if (annotation != null) {
                String[] contents = content.split(annotation.separator());
                if (contents.length > 0) this.Public_UnPackage(contents);
            }
        }
        return (T) this;
    }

    /**
     * @description: 公开协议 拆包
     **/
    default PublicUnPackageObject Public_UnPackage(String[] contents) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        if (contents != null && contents.length > 0) {
            DataClass class_annotation = this.getClass().getAnnotation(DataClass.class);
            if (class_annotation != null) {
                return this.Public_UnPackage(contents, this.Public_Fields());
            }
        }
        return new PublicUnPackageObject(unPackage.getSurplusContents(), this);
    }

    /**
     * @description: 直接赋值
     **/
    default T Public_UnPackage_No_Reflex(String[] all_fields) {
        return (T) this;
    }

    /**
     * @description: 公开协议 拆包
     **/
    default PublicUnPackageObject Public_UnPackage(String[] contents, List<Field> fields) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        if (contents != null && contents.length > 0) {
            DataClass class_annotation = this.getClass().getAnnotation(DataClass.class);
            if (class_annotation != null) {
                if (fields == null) fields = this.Public_Fields();
                if (fields != null && !fields.isEmpty()) {
                    for (Field field : fields) {
                        long start = System.currentTimeMillis();
                        PublicField field_annotation = field.getAnnotation(PublicField.class);
                        if (field_annotation != null) {
                            unPackage = this.Public_Field_UnPackage(unPackage.getSurplusContents(), class_annotation, field_annotation);
                            try {
                                if (((PublicUnPackageObject) unPackage).getObj() != null) {
                                    field.setAccessible(true);
                                    if (class_annotation.print())
                                        System.out.println(String.format("Public_UnPackage %s - %s - %s",
                                                this.getClass().getSimpleName(), field.getName(), JSONUtils.objectToJSON(((PublicUnPackageObject) unPackage).getObj())));
                                    field.set(this, ((PublicUnPackageObject) unPackage).getObj());
                                }
                            } catch (IllegalAccessException e) {
                                System.err.println(String.format("Public_UnPackage %s - %s - %s",
                                        this.getClass().getSimpleName(), field.getName(), e.getMessage()));
                                e.printStackTrace();
                            }
                        }
                        long end = System.currentTimeMillis();
                        // System.out.println(String.format("Field:[%s] Time:[%s]", field.getName(), (end - start)));
                    }
                }
            }
        }
        return new PublicUnPackageObject(unPackage.getSurplusContents(), this);
    }

    /**
     * @description: 公开协议 拆包
     **/
    default T Public_UnPackage_This(String[] contents) {
        this.Public_UnPackage(contents).getObj();
        return (T) this;
    }

    /**
     * @description: 公开协议字段 拆包
     **/
    default PublicUnPackageObject Public_Field_UnPackage(String[] contents, DataClass class_annotation, PublicField field_annotation) {
        Object result = null;
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        // if (contents != null && contents.length > 0) {
        try {
            switch (field_annotation.type()) {
                case LST1_M1:
                    result = new ArrayList<>();
                    boolean run = true, isStart = false;
                    while (run) {
                        int start = 0, end = 0;
                        for (int i = 0; i < unPackage.getSurplusContents().length; i++) {
                            String content = unPackage.getSurplusContents()[i];
                            if (StringUtils.isNotBlank(content) && (content.contains(RES) || content.contains(REE))) {
                                if (content.contains(REE)) run = false;
                                unPackage.getSurplusContents()[i] = content.replace(RES, "")
                                        .replace(REE, "")
                                        .trim();
                                if (start == 0 && !isStart) {
                                    start = i + 1;
                                    isStart = true;
                                } else {
                                    end = i + 1;
                                    break;
                                }
                            }
                        }

                        unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), start, end);
                        PublicUnPackage unPackageArray = new PublicUnPackage(((PublicUnPackageArray) unPackage).getContents());
                        if ("0".equals(unPackageArray.getSurplusContents()[0])) {
                            this.un_package_method(unPackageArray.getSurplusContents(), 2);
                        } else {
                            String[] part_contents = new String[0];
                            unPackageArray = this.contents_copyOfRange(unPackageArray.getSurplusContents(), 8);
                            part_contents = ByteUtils.byteMerger(part_contents, ((PublicUnPackageArray) unPackageArray).getContents());
                            unPackageArray = this.un_package_method(unPackageArray.getSurplusContents(), 0);
                            unPackageArray = this.contents_copyOfRange(unPackageArray.getSurplusContents(), 6);
                            part_contents = ByteUtils.byteMerger(part_contents, ((PublicUnPackageArray) unPackageArray).getContents());
                            unPackageArray = this.un_package_method(unPackageArray.getSurplusContents(), 1);
                            part_contents = ByteUtils.byteMerger(part_contents, unPackageArray.getSurplusContents());
                            part_contents = Arrays.copyOfRange(part_contents, 1, part_contents.length);
                            PublicUnPackageObject unPackageObject = ((FieldModel) (field_annotation.list_class().newInstance())).Public_UnPackage(part_contents);
                            ((ArrayList) result).add((unPackageObject).getObj());
                        }
                    }
                    break;
                case LST:
                    unPackage = this.contents_copyOfRange(contents, 1);
                    String[] cs = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs != null && cs.length > 0) {
                        String content_list = cs[0];
                        if (StringUtils.isNotBlank(content_list)) {
                            String[] splits = content_list.split(field_annotation.set_split());
                            result = new ArrayList<>();
                            while (splits.length > 0) {
                                PublicUnPackageObject unPackageObject = this.Public_Field_UnPackage(null, field_annotation.list_type(), field_annotation.field_length(),
                                        field_annotation.list_class(), splits);
                                if (unPackageObject.getObj() != null)
                                    ((ArrayList) result).add(unPackageObject.getObj());
                                splits = unPackageObject.getSurplusContents();
                            }
                        }
                    }
                    break;
                case MAP:
                    unPackage = this.contents_copyOfRange(contents, 1);
                    String content_map = ((PublicUnPackageArray) unPackage).getContents()[0];
                    if (StringUtils.isNotBlank(content_map)) {
                        String[] splits = content_map.split(field_annotation.set_split());
                        result = new HashMap<>();
                        for (String split : splits) {
                            String[] kv = split.split(field_annotation.set_kv_split());
                            PublicUnPackageObject key = this.Public_Field_UnPackage(null, field_annotation.map_key_type(), field_annotation.field_length(),
                                    field_annotation.map_key_class(), kv[0]);
                            PublicUnPackageObject value = this.Public_Field_UnPackage(null, field_annotation.map_val_type(), field_annotation.field_length(),
                                    field_annotation.map_val_class(), kv[1]);
                            if (key.getObj() != null && value.getObj() != null)
                                ((HashMap) result).put(key.getObj(), value.getObj());
                        }
                    }
                    break;
                default:
                    unPackage = this.Public_Field_UnPackage(field_annotation, field_annotation.type(), field_annotation.field_length(), field_annotation.field_class(), contents);
                    result = ((PublicUnPackageObject) unPackage).getObj();
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        // }
        return new PublicUnPackageObject(unPackage.getSurplusContents(), result);
    }

    /**
     * @description: 公开协议字段 拆包
     **/
    default PublicUnPackageObject Public_Field_UnPackage(PublicField field_annotation, int type, int length, Class clazz, String... contents) {
        Object result = null;
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        try {
            switch (type) {
                case INT:
                    unPackage = this.contents_copyOfRange(contents, length);
                    String[] cs_int = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs_int != null && cs_int.length > 0 && StringUtils.isNotBlank(cs_int[0])) {
                        result = Integer.parseInt(cs_int[0]);
                    } else if (field_annotation != null && StringUtils.isNotBlank(field_annotation.defaultVal())) {
                        result = Integer.parseInt(field_annotation.defaultVal());
                    }
                    break;
                case DOUBLE:
                    unPackage = this.contents_copyOfRange(contents, length);
                    String[] cs_double = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs_double != null && cs_double.length > 0 && StringUtils.isNotBlank(cs_double[0])) {
                        result = Double.parseDouble(cs_double[0]);
                    } else if (field_annotation != null && StringUtils.isNotBlank(field_annotation.defaultVal())) {
                        result = Double.parseDouble(field_annotation.defaultVal());
                    }
                    break;
                case LNG:
                    unPackage = this.contents_copyOfRange(contents, length);
                    String[] cs_lng = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs_lng != null && cs_lng.length > 0 && StringUtils.isNotBlank(cs_lng[0])) {
                        result = Long.parseLong(cs_lng[0]);
                    } else if (field_annotation != null && StringUtils.isNotBlank(field_annotation.defaultVal())) {
                        result = Long.parseLong(field_annotation.defaultVal());
                    }
                    break;
                case LNT:
                    unPackage = this.contents_copyOfRange(contents, length == 0 ? 6 : length);
                    Date date = this.dateUnPackage(((PublicUnPackageArray) unPackage).getContents());
                    result = date != null ? date.getTime() : date;
                    break;
                case TME:
                    unPackage = this.contents_copyOfRange(contents, length == 0 ? 6 : length);
                    result = this.dateUnPackage(((PublicUnPackageArray) unPackage).getContents());
                    break;
                case TME_M1:
                    unPackage = this.contents_copyOfRange(contents, length == 0 ? 6 : length);
                    result = this.dateUnPackage1(((PublicUnPackageArray) unPackage).getContents());
                    break;
                case BDL:
                    unPackage = this.contents_copyOfRange(contents, length);
                    String[] cs_bdl = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs_bdl != null && cs_bdl.length > 0 && StringUtils.isNotBlank(cs_bdl[0])) {
                        result = BigDecimalUtils.stringToBigDecimal(cs_bdl[0]);
                    } else if (field_annotation != null && StringUtils.isNotBlank(field_annotation.defaultVal())) {
                        result = new BigDecimal(field_annotation.defaultVal());
                    }
                    break;
                case FML:
                    unPackage = this.contents_copyOfRange(contents, length);
                    String[] cs_fml = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs_fml != null && StringUtils.isNotBlank(cs_fml[0])) {
                        result = (((FieldModel) (clazz.newInstance())).Public_UnPackage_WithOut_SE(contents[0]));
                    }
                    break;
                case FML_M1:
                    unPackage = this.contents_copyOfRange(contents, length);
                    result = (((FieldModel) (clazz.newInstance())).Public_UnPackage(((PublicUnPackageArray) unPackage).getContents())).getObj();
                    break;
                case TXT:
                    unPackage = this.contents_copyOfRange(contents, length);
                    String[] cs_txt = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs_txt != null && cs_txt.length > 0 && StringUtils.isNotBlank(cs_txt[0])) {
                        result = ByteUtils.tryParseFromString(cs_txt[0]);
                    } else if (field_annotation != null) {
                        result = field_annotation.defaultVal();
                    }
                    break;
                case TXT_M1:
                    unPackage = this.contents_copyOfRange(contents, length);
                    String[] cs_txt_m1 = ((PublicUnPackageArray) unPackage).getContents();
                    if (cs_txt_m1 != null && cs_txt_m1.length > 0 && StringUtils.isNotBlank(cs_txt_m1[0])) {
                        result = cs_txt_m1[0];
                    } else if (field_annotation != null && StringUtils.isNotBlank(field_annotation.defaultVal())) {
                        result = field_annotation.defaultVal();
                    }
                    break;
                case M0:
                    unPackage = this.un_package_method(contents, 0);
                    break;
                case M1:
                    unPackage = this.un_package_method(contents, 1);
                    break;
                case M2:
                    unPackage = this.un_package_method(contents, 2);
                    break;
                case M3:
                    unPackage = this.un_package_method(contents, 3);
                    break;
                case M4:
                    unPackage = this.un_package_method(contents, 4);
                    break;
                case M5:
                    unPackage = this.un_package_method(contents, 5);
                    break;
                case M6:
                    unPackage = this.un_package_method(contents, 6);
                    break;
                case M7:
                    unPackage = this.un_package_method(contents, 7);
                    break;
            }
        } catch (Exception e) {
            System.err.println(String.format("Public_Field_UnPackage %s-%s-%s", type, contents, e.getMessage()));
            e.printStackTrace();
        }
        return new PublicUnPackageObject(unPackage.getSurplusContents(), result);
    }

    /**
     * @description: 内容截取
     **/
    default PublicUnPackageArray contents_copyOfRange(String[] contents, int length) {
        try {
            return new PublicUnPackageArray(
                    Arrays.copyOfRange(contents, length, contents.length),
                    Arrays.copyOf(contents, length)
            );
        } catch (Exception e) {
            return new PublicUnPackageArray(
                    contents,
                    null
            );
        }
    }

    /**
     * @description: 内容截取
     **/
    default PublicUnPackageArray contents_copyOfRange(String[] contents, int start, int end) {
        return new PublicUnPackageArray(
                Arrays.copyOfRange(contents, end, contents.length),
                Arrays.copyOfRange(contents, start, end)

        );
    }

    /**
     * @description: 时间解包
     **/
    default Date dateUnPackage(String[] contents) {
        if (contents.length == 6) {
            StringBuffer tim_date = new StringBuffer();
            for (int i = 0; i < 6; i++) {
                tim_date.append(contents[i])
                        .append(i == 5 ? "" : " ");
            }
            return DateUtils.getDateTime_YYYY_MM_DD_HH_MM_SS_Space(tim_date.toString());
        }
        return null;
    }

    /**
     * @description: 时间解包
     **/
    default Date dateUnPackage1(String[] contents) {
        if (contents.length == 6) {
            StringBuffer tim_date = new StringBuffer();
            for (int i = 0; i < 6; i++) {
                tim_date.append(contents[i])
                        .append(i == 5 ? "" : " ");
            }
            return DateUtils.getDateTime_YY_MM_DD_HH_MM_SS_Space(tim_date.toString());
        }
        return null;
    }

    /**
     * @description: List Map 默认值转换
     **/
    default Object defaultVal(int type, String defaultVal, Class clazz1, Class clazz2) {
        Object result = null;
        if (StringUtils.isNotBlank(defaultVal)) {
            switch (type) {
                case LST:
                    result = GJSONUtils.jsonToList(defaultVal, clazz1);
                    break;
                case MAP:
                    Map map = GJSONUtils.jsonToObject(defaultVal, Map.class);
                    if (map != null) {
                        result = new HashMap<>();
                        for (Object key : map.keySet()) {
                            ((HashMap) result).put(GJSONUtils.objectToObject(key, clazz1),
                                    GJSONUtils.objectToObject(map.get(key), clazz2));
                        }
                    }
                    break;
            }
        }
        return result;
    }

    /**
     * @description: 默认值转换
     **/
    default Object defaultVal(String defaultVal, Class clazz) {
        if (StringUtils.isNotBlank(defaultVal)) {
            try {
                if (Integer.class.equals(clazz)) {
                    return Integer.parseInt(defaultVal);
                } else if (Long.class.equals(clazz)) {
                    return Long.parseLong(defaultVal);
                } else if (Date.class.equals(clazz)) {
                    return DateUtils.timeStrFormat(defaultVal);
                } else if (BigDecimal.class.equals(clazz)) {
                    return new BigDecimal(defaultVal);
                } else if (FieldModel.class.equals(clazz) || FieldModel.class.isAssignableFrom(clazz)) {
                    return GJSONUtils.jsonToObject(defaultVal, clazz);
                } else if (String.class.equals(clazz)) {
                    return defaultVal;
                }
            } catch (Exception e) {
                System.err.println(String.format("DefaultVal %s-%s-%e", clazz.getSimpleName(), defaultVal, e.getMessage()));
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * @description: 拆包
     **/
    default Integer toInteger(String[] all_fields, int index) {
        return this.toInteger(all_fields, index, ZERO);
    }

    default Integer toInteger(String[] all_fields, int index, Integer def) {
        try {
            return this.toIntegerDefault(all_fields, index, def);
        } catch (Exception e) {
            return Objects.nonNull(def) ? def : ZERO;
        }
    }

    default Integer toIntegerDefault(String[] all_fields, int index) {
        return this.toIntegerDefault(all_fields, index, ZERO);
    }

    default Integer toIntegerDefault(String[] all_fields, int index, Integer def) {
        return Integer.parseInt(this.toString(all_fields, index, def));
    }

    default String toString(String[] all_fields, int index) {
        return this.toString(all_fields, index, "");
    }

    default String toText(String[] all_fields, int index) {
        return ByteUtils.tryParseFromString(this.toString(all_fields, index));
    }

    default String toText(String[] all_fields, int index, String def) {
        return ByteUtils.tryParseFromString(this.toString(all_fields, index, def));
    }

    default List<String> toStringList(String[] all_fields, int index) {
        String str = this.toString(all_fields, index);
        if (StringUtils.isNotBlank(str)) {
            return Arrays.asList(str.split(PUBLIC_SET_FIELD_SPLIT));
        } else {
            return null;
        }
    }

    default List<Integer> toIntegerList(String[] all_fields, int index) {
        List<String> strList = this.toStringList(all_fields, index);
        List<Integer> integerList = new ArrayList<>();
        if (strList != null && !strList.isEmpty()) {
            for (String str : strList) {
                if (StringUtils.isNotBlank(str))
                    integerList.add(Integer.parseInt(str));
            }
        }
        return integerList;
    }

    default BigDecimal toBigDecimal(String[] all_fields, int index) {
        return BigDecimalUtils.stringToBigDecimal(this.toString(all_fields, index));
    }

    default String toString(String[] all_fields, int index, Object def) {
        try {
            return all_fields[index].trim();
        } catch (Exception e) {
            return Objects.nonNull(def) ? def.toString() : "";
        }
    }

    /**
     * @description: 组包
     **/
    default String to_append_text(String text) {
        return this.to_append(ByteUtils.tryParseToString(text), "");
    }

    default String to_append(BigDecimal bigDecimal) {
        return this.to_append_bigDecimal(bigDecimal);
    }

    default String to_append_bigDecimal(BigDecimal bigDecimal) {
        return this.to_append(BigDecimalUtils.bigDecimalToString(bigDecimal));
    }

    default String to_append_length(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; i++) {
            builder.append(this.to_append(null));
        }
        return builder.toString();
    }

    default String to_append_list(List<String> texts, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; i++) {
            try {
                String text = texts.get(i);
                if (StringUtils.isNotBlank(text))
                    builder.append(text);
            } catch (Exception e) {
            }
            builder.append(PUBLIC_FIELD_SPLIT);
        }
        return builder.toString();
    }

    default String to_append_list(List list) {
        StringBuilder builder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); i++) {
                Object o = list.get(i);
                builder.append(Objects.nonNull(o) ? o.toString() : "")
                        .append(i != list.size() - 1 ? PUBLIC_SET_FIELD_SPLIT : "");
            }
        }
        return this.to_append(builder.toString());
    }

    default String to_append(Object obj) {
        return this.to_append(obj, "");
    }

    default String to_append(Object obj, Object def) {
        return (Objects.nonNull(obj) ? obj : (Objects.nonNull(def) ? def : "")).toString() + PUBLIC_FIELD_SPLIT;
    }
}