package com.jhscale.common.model.inter;

import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.utils.JSONUtils;
import org.apache.commons.lang3.StringUtils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lie_w
 * @title: MapModel
 * @projectName common
 * @description: TODO
 * @date 2020-11-1416:14
 */
@SuppressWarnings("all")
public interface MapModel extends Serializable {

    /**
     * @description: 转Map
     * @date: 2024-11-22 09:42:03
     **/
    default Map<String, Object> toMap() {
        Class clazz = getClass();
        Map<String, Object> maps = new HashMap<String, Object>();
        PropertyDescriptor[] propertyDescriptors = null;
        try {
            propertyDescriptors = propertyDescriptors(clazz);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                Method gmethod = propertyDescriptor.getReadMethod();
                Method smethod = propertyDescriptor.getWriteMethod();
                if (null != gmethod && smethod != null) {
                    try {
                        maps.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod().invoke(this));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return maps;
        } catch (TechnologyException e) {
            return null;
        }
    }

    /**
     * @description: 转String Map
     * @date: 2024-11-22 09:41:54
     **/
    default Map<String, String> toStringMap() {
        Map<String, Object> map = this.toMap();
        Map<String, String> stringMap = new HashMap<String, String>();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (Objects.nonNull(value)) {
                    if (value instanceof com.jhscale.common.model.inter.JSONModel) {
                        stringMap.put(key, ((com.jhscale.common.model.inter.JSONModel) value).toJSON());
                    } else if (value instanceof com.jhscale.common.model.simple.JSONModel) {
                        stringMap.put(key, ((com.jhscale.common.model.simple.JSONModel) value).toJSON());
                    } else if (value instanceof String || value instanceof BigDecimal) {
                        stringMap.put(key, value.toString());
                    } else if (value instanceof Integer || value instanceof Long
                            || value instanceof Float || value instanceof Double) {
                        stringMap.put(key, String.valueOf(value));
                    } else {
                        stringMap.put(key, JSONUtils.objectToJSON(value));
                    }
                }
            }
        }
        return stringMap;
    }

    /**
     * @description: 字段填充
     * @date: 2024-11-22 09:41:14
     **/
    default void fillStringMap(Map<String, String> stringMap) {
        if (stringMap != null && !stringMap.isEmpty()) {
            Map<String, Field> stringFieldMap = this.allField();
            for (Map.Entry<String, Field> entry : stringFieldMap.entrySet()) {
                String key = entry.getKey();
                String value = stringMap.get(entry.getKey());
                if (StringUtils.isNotBlank(value)) {
                    try {
                        Field field = entry.getValue();
                        field.setAccessible(true);
                        if (field.getType().equals(String.class)) {
                            field.set(this, value);
                        } else if (field.getType().equals(int.class)) {
                            field.setInt(this, Integer.parseInt(value));
                        } else if (field.getType().equals(Integer.class)) {
                            field.set(this, Integer.parseInt(value));
                        } else if (field.getType().equals(long.class)) {
                            field.setLong(this, Long.parseLong(value));
                        } else if (field.getType().equals(Long.class)) {
                            field.set(this, Long.parseLong(value));
                        } else if (field.getType().equals(float.class)) {
                            field.setFloat(this, Float.parseFloat(value));
                        } else if (field.getType().equals(Float.class)) {
                            field.set(this, Float.parseFloat(value));
                        } else if (field.getType().equals(double.class)) {
                            field.setDouble(this, Double.parseDouble(value));
                        } else if (field.getType().equals(Double.class)) {
                            field.set(this, Double.parseDouble(value));
                        } else if (field.getType().equals(boolean.class)) {
                            field.setBoolean(this, Boolean.parseBoolean(value));
                        } else if (field.getType().equals(Boolean.class)) {
                            field.set(this, Boolean.parseBoolean(value));
                        } else if (field.getType().equals(BigDecimal.class)) {
                            field.set(this, new BigDecimal(value));
                        } else if (field.getType().equals(List.class)) {
                            Type genericType = field.getGenericType();
                            Class innerClazz = null;
                            if (genericType instanceof ParameterizedType) {
                                innerClazz = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments
                                        ()[0];
                            }
                            field.set(this, JSONUtils.jsonToList(value, innerClazz));
                        } else if (field.getType().equals(Map.class)) {
                            field.set(this, JSONUtils.jsonToObject(value, Map.class));
                        } else {
                            field.set(this, JSONUtils.jsonToObject(value, field.getType()));
                        }
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    default PropertyDescriptor[] propertyDescriptors(Class<?> c) throws TechnologyException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        } catch (IntrospectionException var4) {
            throw new TechnologyException(var4, "Bean introspection failed: " + var4.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    /**
     * @description: 获取所有的字段
     **/
    default Map<String, Field> allField(String... ignoreArr) {
        Map<String, Field> fieldMap = new HashMap<>();
        allField(this.getClass(), fieldMap, ignoreArr);
        return fieldMap;
    }

    /**
     * @description: 获取自身所有的字段（不包括父类）
     **/
    default Map<String, Field> field(String... ignoreArr) {
        List<String> ingrols = null;
        Map<String, Field> fieldMap = new HashMap<>();
        if (ignoreArr != null) ingrols = Arrays.asList(ignoreArr);
        Field[] fields = this.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (ingrols == null || !ingrols.contains(field.getName()))
                    fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap;
    }

    /**
     * @description: 获取所有的字段
     **/
    default List<Field> allFieldList(String... ignoreArr) {
        Map<String, Field> map = this.allField(ignoreArr);
        return Optional.ofNullable(map).orElse(Collections.emptyMap()).values().stream().map(field -> {
            return field;
        }).collect(Collectors.toList());
    }

    /**
     * @description: 获取所有的字段
     **/
    default Map<String, Field> allAndroidField() {
        return this.allField("shadow$_klass_", "shadow$_monitor_");
    }

    /**
     * @description: 字段Map按照英文字符正序排列
     **/
    default List<String> sortMapKey(Map<String, Field> fieldMap) {
        if (fieldMap != null && !fieldMap.isEmpty()) {
            Set<String> keys = fieldMap.keySet();
            String[] keyArray = keys.toArray(new String[fieldMap.size()]);
            Arrays.sort(keyArray, String.CASE_INSENSITIVE_ORDER);
            return Arrays.asList(keyArray);
        }
        return null;
    }

    /**
     * @description: 递归
     **/
    default void allField(Class clazz, Map<String, Field> fieldMap, String... ignoreArr) {
        List<String> ingrols = null;
        if (ignoreArr != null) ingrols = Arrays.asList(ignoreArr);
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (ingrols == null || !ingrols.contains(field.getName()))
                    fieldMap.put(field.getName(), field);
            }
        }

        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null)
            allField(superclass, fieldMap, ignoreArr);
    }
}
