package com.jhscale.common.model.license;

import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.utils.JRSAUtil;
import org.apache.commons.codec.binary.Base64;

/**
 * @author lie_w
 * @title: JRSAEncryptDecrypt
 * @projectName common
 * @description: JAVA证书加解密
 * @date 2022/2/2016:43
 */
public class JRSAEncryptDecrypt implements RSAEncryptDecrypt {

    /**
     * @description: 生成密钥对(公钥和私钥)
     **/
    @Override
    public RSAKey genKeyPair() throws TechnologyException {
        return JRSAUtil.genKeyPair();
    }

    /**
     * @param encryptedData
     * @param privateKey
     * @description: 私钥解密
     */
    @Override
    public String decryptByPrivateKey(String encryptedData, String privateKey) throws TechnologyException {
        return JRSAUtil.decryptByPrivateKey(encryptedData, privateKey);
    }

    /**
     * @param encryptedData
     * @param privateKey
     * @description: 私钥解密
     */
    @Override
    public byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws TechnologyException {
        return JRSAUtil.decryptByPrivateKey(encryptedData, privateKey);
    }

    /**
     * @param data
     * @param publicKey
     * @description: 公钥加密
     */
    @Override
    public String encryptByPublicKey(String data, String publicKey) throws TechnologyException {
        return JRSAUtil.encryptByPublicKey(data, publicKey);
    }

    /**
     * @param data
     * @param publicKey
     * @description: 公钥加密
     */
    @Override
    public byte[] encryptByPublicKey(byte[] data, String publicKey) throws TechnologyException {
        return JRSAUtil.encryptByPublicKey(data, publicKey);
    }

    /**
     * @param encryptedData
     * @param publicKey
     * @description: 公钥解密
     */
    @Override
    public String decryptByPublicKey(String encryptedData, String publicKey) throws TechnologyException {
        return JRSAUtil.decryptByPublicKey(encryptedData, publicKey);
    }

    /**
     * @param encryptedData
     * @param publicKey
     * @description: 公钥解密
     */
    @Override
    public byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws TechnologyException {
        return JRSAUtil.decryptByPublicKey(encryptedData, publicKey);
    }

    /**
     * @param data
     * @param privateKey
     * @description: 私钥加密
     */
    @Override
    public String encryptByPrivateKey(String data, String privateKey) throws TechnologyException {
        return JRSAUtil.encryptByPrivateKey(data, privateKey);
    }

    /**
     * @param data
     * @param privateKey
     * @description: 私钥加密
     */
    @Override
    public byte[] encryptByPrivateKey(byte[] data, String privateKey) throws TechnologyException {
        return JRSAUtil.encryptByPrivateKey(data, privateKey);
    }

    /**
     * @param source
     * @description: base64 encrypt
     */
    @Override
    public byte[] encrypt(byte[] source) {
        return Base64.encodeBase64(source);
    }

    @Override
    public String encrypt(String source) {
        return new String(this.encrypt(source.getBytes()));
    }

    @Override
    public String encode(byte[] source) {
        return Base64.encodeBase64String(source);
    }

    @Override
    public byte[] encode(String source) {
        return Base64.encodeBase64(source.getBytes());
    }

    /**
     * @param source
     * @description: base64 decrypt
     */
    @Override
    public byte[] decrypt(byte[] source) {
        return Base64.decodeBase64(source);
    }

    @Override
    public String decrypt(String source) {
        return new String(this.decrypt(source.getBytes()));
    }

    @Override
    public byte[] decode(String source) {
        return Base64.decodeBase64(source);
    }

    @Override
    public String decode(byte[] source) {
        return new String(Base64.decodeBase64(source));
    }
}
