package com.jhscale.common.model.license;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.content.JHContents;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.utils.MD5Utils;
import com.jhscale.common.utils.RandomUtils;
import io.swagger.annotations.ApiModel;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author lie_w
 * @title: LicenseContent
 * @projectName common
 * @description: TODO
 * @date 2022/2/1814:52
 */
@ApiModel("证书内容")
public class LicenseContent extends JSONModel {

    private LicenseHolder licenseHolder;

    /**
     * @description: 生产版本
     * @date: 2025-03-05 16:27:54
     **/
    private Integer prodSerial;

    /**
     * @description: 证书subject
     **/
    private String subject;

    /**
     * @description: 证书别名
     **/
    private String alias;

    /**
     * @description: 证书生效时间
     **/
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date issuedTime;

    /**
     * @description: 证书失效时间
     **/
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expiryTime;

    /**
     * @description: 生产时间
     **/
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date prodTime;
    private String prodTimeVal;

    /**
     * @description: 出厂时间
     **/
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mfgTime;
    private String mfgTimeVal;

    /**
     * @description: 有效时间
     **/
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date validTime;
    private String validTimeVal;

    /**
     * 用户类型
     */
    private String consumerType = "user";

    /**
     * 用户数量
     */
    private Integer consumerAmount = 1;

    /**
     * 描述信息
     */
    private String description = "";

    /**
     * @description: 随机字符串[必填]
     * @date: 2025-03-05 16:43:01
     **/
    private String nonce;

    /**
     * @description: 证书签名防止被串改
     * @date: 2025-03-05 16:40:46
     **/
    private String sign;

    /**
     * 额外的服务器硬件校验信息
     */
    private LicenseParam licenseParam;

    /**
     * @description: 证书尾
     **/
    private LicenseIssuer licenseIssuer;

    /**
     * @description: 生成证书签名
     * @date: 2025-03-05 16:43:20
     **/
    public void sign() {
        LicenseVersion serial = LicenseVersion.serial(this.prodSerial);
        if (Objects.nonNull(serial)) {
            switch (serial) {
                case VERSION1:
                    this.nonce = StringUtils.isNotBlank(this.nonce) ? this.nonce : RandomUtils.getRandomHexUpper(32);
                    StringBuilder privateKey = new StringBuilder();
                    for (int i = 0; i < nonce.length(); i++) {
                        privateKey.append(i % 2 == 0 ? nonce.charAt(i) : "");
                    }
                    this.sign = MD5Utils.bulidMD5Signature(MD5Utils.bulidSourceSignature_date(this.toObjMap(), privateKey.toString()));
                    break;
            }
        }

    }

    /**
     * @description: 加密证书内容
     **/
    public String encryptByPrivateKey(RSAEncryptDecrypt rsa, String privateKey) throws TechnologyException {
        return rsa.encryptByPrivateKey(this.toJSON(), privateKey);
    }

    public String encryptByPrivateKey(RSAEncryptDecrypt rsa, RSAKey rsaKey) throws TechnologyException {
        return rsa.encrypt(this.encryptByPrivateKey(rsa, rsaKey.getPrivateKey()) + JHContents.DEFAULT_SPLIT + rsaKey.getPublicKey());
    }

    public String encryptByPublicKey(RSAEncryptDecrypt rsa, String publicKey) throws TechnologyException {
        return rsa.encryptByPublicKey(this.toJSON(), publicKey);
    }

    public String encryptByPublicKey(RSAEncryptDecrypt rsa, RSAKey rsaKey) throws TechnologyException {
        return rsa.encrypt(this.encryptByPublicKey(rsa, rsaKey.getPublicKey()) + JHContents.DEFAULT_SPLIT + rsaKey.getPrivateKey());
    }

    /**
     * @description: 解密证书内容
     **/
    public static LicenseContent decryptByPublicKey(RSAEncryptDecrypt rsa, String encrypt, String publicKey) throws TechnologyException {
        return JSONUtils.jsonToObject(rsa.decryptByPublicKey(encrypt, publicKey), LicenseContent.class);
    }

    public static LicenseContent decryptByPublicKey(RSAEncryptDecrypt rsa, String encrypt) throws TechnologyException {
        return JSONUtils.jsonToObject(decryptByPublicKeyRString(rsa, encrypt), LicenseContent.class);
    }

    public static String decryptByPublicKeyRString(RSAEncryptDecrypt rsa, String encrypt) throws TechnologyException {
        String[] encryptArr = rsa.decrypt(encrypt).split(JHContents.DEFAULT_SPLIT);
        return rsa.decryptByPublicKey(encryptArr[0], encryptArr[1]);
    }

    public static LicenseContent decryptByPrivateKey(RSAEncryptDecrypt rsa, String encrypt, String privateKey) throws TechnologyException {
        return JSONUtils.jsonToObject(rsa.decryptByPrivateKey(encrypt, privateKey), LicenseContent.class);
    }

    public static LicenseContent decryptByPrivateKey(RSAEncryptDecrypt rsa, String encrypt) throws TechnologyException {
        String[] encryptArr = rsa.decrypt(encrypt).split(JHContents.DEFAULT_SPLIT);
        return JSONUtils.jsonToObject(rsa.decryptByPrivateKey(encryptArr[0], encryptArr[1]), LicenseContent.class);
    }

    public LicenseHolder getLicenseHolder() {
        return licenseHolder;
    }

    public void setLicenseHolder(LicenseHolder licenseHolder) {
        this.licenseHolder = licenseHolder;
    }

    public Integer getProdSerial() {
        return prodSerial;
    }

    public void setProdSerial(Integer prodSerial) {
        this.prodSerial = prodSerial;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Date getIssuedTime() {
        return issuedTime;
    }

    public void setIssuedTime(Date issuedTime) {
        this.issuedTime = issuedTime;
    }

    public Date getExpiryTime() {
        return expiryTime;
    }

    public void setExpiryTime(Date expiryTime) {
        this.expiryTime = expiryTime;
    }

    public Date getProdTime() {
        return prodTime;
    }

    public void setProdTime(Date prodTime) {
        this.prodTime = prodTime;
        this.prodTimeVal = ByteUtils.timeToStrNone(prodTime);
    }

    public Date getMfgTime() {
        return mfgTime;
    }

    public void setMfgTime(Date mfgTime) {
        this.mfgTime = mfgTime;
        this.mfgTimeVal = ByteUtils.timeToStrNone(mfgTime);
    }

    public Date getValidTime() {
        return validTime;
    }

    public void setValidTime(Date validTime) {
        this.validTime = validTime;
        this.validTimeVal = ByteUtils.timeToStrNone(validTime);
    }

    public String getProdTimeVal() {
        return prodTimeVal;
    }

    public void setProdTimeVal(String prodTimeVal) {
        this.prodTimeVal = prodTimeVal;
    }

    public String getMfgTimeVal() {
        return mfgTimeVal;
    }

    public void setMfgTimeVal(String mfgTimeVal) {
        this.mfgTimeVal = mfgTimeVal;
    }

    public String getValidTimeVal() {
        return validTimeVal;
    }

    public void setValidTimeVal(String validTimeVal) {
        this.validTimeVal = validTimeVal;
    }

    public String getConsumerType() {
        return consumerType;
    }

    public void setConsumerType(String consumerType) {
        this.consumerType = consumerType;
    }

    public Integer getConsumerAmount() {
        return consumerAmount;
    }

    public void setConsumerAmount(Integer consumerAmount) {
        this.consumerAmount = consumerAmount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNonce() {
        return nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public LicenseParam getLicenseParam() {
        return licenseParam;
    }

    public void setLicenseParam(LicenseParam licenseParam) {
        this.licenseParam = licenseParam;
    }

    public LicenseIssuer getLicenseIssuer() {
        return licenseIssuer;
    }

    public void setLicenseIssuer(LicenseIssuer licenseIssuer) {
        this.licenseIssuer = licenseIssuer;
    }

    @Override
    public String toString() {
        return "LicenseContent{" +
                "licenseHolder=" + licenseHolder +
                ", subject='" + subject + '\'' +
                ", alias='" + alias + '\'' +
                ", issuedTime=" + issuedTime +
                ", expiryTime=" + expiryTime +
                ", consumerType='" + consumerType + '\'' +
                ", consumerAmount=" + consumerAmount +
                ", description='" + description + '\'' +
                ", licenseParam=" + licenseParam +
                ", licenseIssuer=" + licenseIssuer +
                '}';
    }
}
