package com.jhscale.common.model.license;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * @author lie_w
 * @title: LicenseHolder
 * @projectName common
 * @description: TODO
 * @date 2022/2/1813:02
 */
@ApiModel("证书头信息")
public class LicenseHolder extends JSONModel {

    // 姓氏
    private String CN = JHContents.LOCAL_HOST;

    // 组织单位
    private String OU = JHContents.LOCAL_HOST;

    // 组织名称
    private String O = JHContents.LOCAL_HOST;

    // 城市区域
    private String L = JHContents.LOCAL_HOST;

    // 省/市/自治区
    private String ST = JHContents.LOCAL_HOST;

    // 国家/地区
    private String C = JHContents.LOCAL_HOST;

    @SuppressWarnings("ALL")
    public String holder() {
        Map<String, Field> fieldMap = super.allAndroidField();
        StringBuffer buffer = new StringBuffer();
        fieldMap.forEach((key, field) -> {
            try {
                field.setAccessible(true);
                Object o = field.get(this);
                if (o != null) {
                    buffer.append(key)
                            .append("=")
                            .append(o.toString())
                            .append(", ");
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        return buffer.length() == 0 ? "" : buffer.substring(0, buffer.length() - 2);
    }

    public String getCN() {
        return CN;
    }

    public void setCN(String CN) {
        this.CN = CN;
    }

    public String getOU() {
        return OU;
    }

    public void setOU(String OU) {
        this.OU = OU;
    }

    public String getO() {
        return O;
    }

    public void setO(String o) {
        O = o;
    }

    public String getL() {
        return L;
    }

    public void setL(String l) {
        L = l;
    }

    public String getST() {
        return ST;
    }

    public void setST(String ST) {
        this.ST = ST;
    }

    public String getC() {
        return C;
    }

    public void setC(String c) {
        C = c;
    }
}
