package com.jhscale.common.model.license;

import com.jhscale.common.exception.TechnologyException;

/**
 * @author lie_w
 * @title: RSAEncryptDecrypt
 * @projectName common
 * @description: TODO
 * @date 2022/2/2016:28
 */
public interface RSAEncryptDecrypt {

    /**
     * @description: 生成密钥对(公钥和私钥)
     **/
    RSAKey genKeyPair() throws TechnologyException;

    /**
     * @description: 私钥解密
     **/
    String decryptByPrivateKey(String encryptedData, String privateKey) throws TechnologyException;

    /**
     * @description: 私钥解密
     **/
    byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws TechnologyException;

    /**
     * @description: 公钥加密
     **/
    String encryptByPublicKey(String data, String publicKey) throws TechnologyException;

    /**
     * @description: 公钥加密
     **/
    byte[] encryptByPublicKey(byte[] data, String publicKey) throws TechnologyException;

    /**
     * @description: 公钥解密
     **/
    String decryptByPublicKey(String encryptedData, String publicKey) throws TechnologyException;

    /**
     * @description: 公钥解密
     **/
    byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws TechnologyException;

    /**
     * @description: 私钥加密
     **/
    String encryptByPrivateKey(String data, String privateKey) throws TechnologyException;

    /**
     * @description: 私钥加密
     **/
    byte[] encryptByPrivateKey(byte[] data, String privateKey) throws TechnologyException;

    /**
     * @description: base64 encrypt
     **/
    byte[] encrypt(byte[] source);

    String encrypt(String source);

    String encode(byte[] source);

    byte[] encode(String source);

    /**
     * @description: base64 decrypt
     **/
    byte[] decrypt(byte[] source);

    String decrypt(String source);

    byte[] decode(String source);

    String decode(byte[] source);
}
