package com.jhscale.common.model.simple;

import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.GJSONUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.jhscale.common.model.device.DConstant.FIELD_MODEL_SPLIT;
import static com.jhscale.common.model.device.DConstant.SPACE;

/**
 * @author Loveven
 * @title: FieldModel
 * @projectName common
 * @description: TODO
 * @date 2021-03-0523:08
 */
public class FieldModel<T extends FieldModel> implements DataJSONModel<T> {

    /**
     * @description: 获取所有的字段键值
     **/
    @Deprecated
    public String assembleFieldVal() {
        Map<String, Field> allField = this.allAndroidField();
        if (allField != null && !allField.isEmpty()) {
            List<String> keys = this.sortMapKey(allField);
            StringBuffer buffer = new StringBuffer();
            keys.forEach(key -> {
                Field field = allField.get(key);
                try {
                    field.setAccessible(true);
                    Object obj = field.get(this);

                    buffer.append(obj != null ? (obj instanceof String ? obj.toString() : GJSONUtils.objectToJSON(obj)) : SPACE)
                            .append(FIELD_MODEL_SPLIT);

                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            return buffer.substring(0, buffer.length() - 1);
        }
        return null;
    }

    /**
     * @description: 解析字段
     **/
    @Deprecated
    public FieldModel parseFieldVal(String data) {
        if (StringUtils.isNotBlank(data)) {
            String[] dataSplits = data.split(FIELD_MODEL_SPLIT);
            if (dataSplits.length > 0) {
                Map<String, Field> allField = this.allAndroidField();
                List<String> keys = this.sortMapKey(allField);
                for (int i = 0; i < keys.size(); i++) {
                    String dataSplit = dataSplits[i];
                    if (StringUtils.isNotBlank(dataSplit)) {
                        try {
                            Field field = allField.get(keys.get(i));
                            field.setAccessible(true);
                            if (field.getType().equals(BigDecimal.class)) {
                                field.set(this, new BigDecimal(dataSplit));
                            } else if (field.getType().equals(Long.class)) {
                                field.set(this, Long.parseLong(dataSplit));
                            } else if (field.getType().equals(Integer.class)) {
                                field.set(this, Integer.parseInt(dataSplit));
                            } else if (field.getType().equals(UnitType.class)) {
                                field.set(this, UnitType.valueOfName(dataSplit));
                            } else if (GJSONUtils.isJSON(dataSplit)) {
                                field.set(this, GJSONUtils.jsonToObject(dataSplit, field.getType()));
                            } else {
                                field.set(this, dataSplit);
                            }
                        } catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return this;
    }
}
