package com.jhscale.common.model.simple;

import com.jhscale.common.em.SequenceRule;
import com.jhscale.common.utils.JSONUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author lie_w
 * @title: Merchant
 * @projectName common
 * @description: TODO
 * @date 2021/3/514:18
 */
@ApiModel("索引关联信息")
public class IndexSign extends JSONModel {

    @ApiModelProperty(value = "编号", name = "sign")
    private IDSign sign;

    @ApiModelProperty(value = "捆绑信息编号", name = "idSignMap")
    private Map<String, IDSign> idSignMap;

    /**
     * @description: 添加
     **/
    public Map<String, IDSign> addIdSignMap(SequenceRule rule, IDSign sign) {
        if (this.idSignMap == null) this.idSignMap = new HashMap<>();
        this.idSignMap.put(rule.getAbbr(), sign);
        return this.idSignMap;
    }

    /**
     * @description: 获取
     **/
    public IDSign idSign(SequenceRule rule) {
        if (this.idSignMap == null) return null;
        return this.idSignMap.get(rule.getAbbr());
    }

    /**
     * @description: 获取信息
     **/
    public <T> T idSign(SequenceRule rule, Class<T> clazz) {
        IDSign idSign = this.idSign(rule);
        return idSign == null || idSign.getInfo() == null ? null : JSONUtils.objectToObject(idSign.getInfo(), clazz);
    }

    /**
     * @description: 获取
     **/
    public IDSign idSign(String rule) {
        if (this.idSignMap == null) return null;
        return this.idSignMap.get(rule);
    }

    public <T> T idSign(String rule, Class<T> clazz) {
        IDSign idSign = this.idSign(rule);
        return idSign == null || idSign.getInfo() == null ? null : JSONUtils.objectToObject(idSign.getInfo(), clazz);
    }

    public IDSign getSign() {
        return sign;
    }

    public void setSign(IDSign sign) {
        this.sign = sign;
    }

    public Map<String, IDSign> getIdSignMap() {
        return idSignMap;
    }

    public void setIdSignMap(Map<String, IDSign> idSignMap) {
        this.idSignMap = idSignMap;
    }

    @ApiModel("索引业务标识")
    public static class IDSign {

        @ApiModelProperty(value = "索引编号", name = "id")
        private Integer id;

        @ApiModelProperty(value = "业务编号", name = "unique")
        private String unique;

        @ApiModelProperty(value = "其他信息", name = "info")
        private Object info;

        /**
         * @description: 获取业务索引标识
         **/
        public Long businessUnique() {
            return StringUtils.isNotBlank(this.unique) ? Long.parseLong(this.unique) : null;
        }

        /**
         * @description: MAC标识
         **/
        public String mac() {
            return this.unique;
        }

        /**
         * @description: 唯一字符串标识
         **/
        public String unique() {
            return this.unique;
        }

        public IDSign() {
        }

        public IDSign(Integer id, String unique) {
            this.id = id;
            this.unique = unique;
        }

        public IDSign(Integer id, Long unique) {
            this.id = id;
            this.unique = Objects.nonNull(unique) ? String.valueOf(unique) : null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            IDSign idSign = (IDSign) o;
            return Objects.equals(id, idSign.id) && Objects.equals(unique, idSign.unique) && Objects.equals(info, idSign.info);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, unique, info);
        }

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public void setUnique(Long unique) {
            this.unique = Objects.nonNull(unique) ? String.valueOf(unique) : null;
        }

        public Object getInfo() {
            return info;
        }

        public void setInfo(Object info) {
            this.info = info;
        }
    }

    @ApiModel("商户具体信息")
    public static class MerchantInfo {
        @ApiModelProperty(value = "用户名", name = "userName")
        private String userName;

        @ApiModelProperty(value = "区号", name = "areaCode")
        private String areaCode;

        @ApiModelProperty(value = "手机", name = "moblie")
        private String moblie;

        @ApiModelProperty(value = "邮箱", name = "email")
        private String email;

        @ApiModelProperty(value = "实名", name = "realName")
        private String realName;

        @ApiModelProperty(value = "区域编号", name = "area")
        private String area;

        @ApiModelProperty(value = "地址", name = "address")
        private String address;

        @ApiModelProperty(value = "经度", name = "lng")
        private BigDecimal lng;

        @ApiModelProperty(value = "维度", name = "lat")
        private BigDecimal lat;

        @ApiModelProperty(value = "时区", name = "timeZone")
        private String timeZone;

        @ApiModelProperty(value = "语言", name = "language")
        private String language;

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getAreaCode() {
            return areaCode;
        }

        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public String getMoblie() {
            return moblie;
        }

        public void setMoblie(String moblie) {
            this.moblie = moblie;
        }

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getRealName() {
            return realName;
        }

        public void setRealName(String realName) {
            this.realName = realName;
        }

        public String getArea() {
            return area;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public String getAddress() {
            return address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public BigDecimal getLng() {
            return lng;
        }

        public void setLng(BigDecimal lng) {
            this.lng = lng;
        }

        public BigDecimal getLat() {
            return lat;
        }

        public void setLat(BigDecimal lat) {
            this.lat = lat;
        }

        public String getTimeZone() {
            return timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public String getLanguage() {
            return language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }
    }
}
