package com.jhscale.common.model.simple;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jhscale.common.utils.JSONUtils;

import java.util.Map;

/**
 * @author lie_w
 * @title: JSONModel
 * @projectName common
 * @description: TODO
 * @date 2020-11-1416:15
 */
public class JSONModel extends MapModel {

    /**
     * @description: 转JSON 字符串
     **/
    public String toJSON() {
        return JSONObject.toJSONString(this, SerializerFeature.WriteDateUseDateFormat);
    }

    /**
     * @description: 转JSON字符串 忽略部分字段
     **/
    public String toJSONIngrol(String... ingrols) {
        Map map = JSONUtils.jsonToObject(this.toJSON(), Map.class);
        if (ingrols != null && ingrols.length > 0) {
            for (String ingrol : ingrols) {
                map.remove(ingrol);
            }
        }
        return JSONObject.toJSONString(map, SerializerFeature.WriteDateUseDateFormat);
    }

    /**
     * @description: 转 对应对象
     **/
    public <T> T toObject(Class<T> clazz) {
        return JSONUtils.objectToObject(this, clazz);
    }
}
