package com.jhscale.common.system;

import com.jhscale.common.exception.ProfessionalException;
import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: LinuxTerminal
 * @projectName common
 * @description: TODO
 * @date 2022/2/1713:14
 */
public class LinuxTerminal extends AbstractTerminal {
    /**
     * @description: 获取IP地址信息
     **/
    @Override
    public List<String> getIpAddresses() throws ProfessionalException {
        List<String> result = new ArrayList<>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            for (InetAddress inetAddress : inetAddresses) {
                result.add(inetAddress.getHostAddress());
            }
        }
        return result;
    }

    /**
     * @description: 获取Mac地址
     **/
    @Override
    protected List<String> getMacAddresses() throws ProfessionalException {
        List<String> result = new ArrayList<>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && inetAddresses.size() > 0) {
            for (InetAddress inetAddress : inetAddresses) {
                String mac = super.getMacByInetAddress(inetAddress);
                if (StringUtils.isNotBlank(mac))
                    result.add(mac);
            }
        }
        return result;
    }

    /**
     * @description: 获取CPU序列号
     **/
    @Override
    protected String getCPUSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        BufferedReader reader = null;
        //序列号
        String serialNumber = null;

        try {
            //使用dmidecode命令获取CPU序列号
            String[] shell = {"/bin/bash", "-c", "dmidecode -t processor | grep 'ID' | awk -F ':' '{print $2}' | head -n 1"};
            Process process = Runtime.getRuntime().exec(shell);
            outputStream = process.getOutputStream();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine().trim();
            if (StringUtils.isNotBlank(line)) {
                serialNumber = line;
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return serialNumber;
    }

    /**
     * @description: 获取主板序列号
     **/
    @Override
    protected String getMainBoardSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        BufferedReader reader = null;
        //序列号
        String serialNumber = null;

        try {
            //使用dmidecode命令获取主板序列号
            String[] shell = {"/bin/bash", "-c", "dmidecode | grep 'Serial Number' | awk -F ':' '{print $2}' | head -n 1"};
            Process process = Runtime.getRuntime().exec(shell);
            outputStream = process.getOutputStream();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine().trim();
            if (StringUtils.isNotBlank(line)) {
                serialNumber = line;
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        return serialNumber;
    }
}
