package com.jhscale.common.system;

import com.jhscale.common.exception.ProfessionalException;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

/**
 * @author lie_w
 * @title: WindowsTerminal
 * @projectName common
 * @description: TODO
 * @date 2022/2/1712:50
 */
public class WindowsTerminal extends AbstractTerminal {
    /**
     * @description: 获取IP地址信息
     **/
    @Override
    public List<String> getIpAddresses() throws ProfessionalException {
        List<String> result = new ArrayList<>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            for (InetAddress inetAddress : inetAddresses) {
                result.add(inetAddress.getHostAddress());
            }
        }
        return result;
    }

    /**
     * @description: 获取Mac地址
     **/
    @Override
    protected List<String> getMacAddresses() throws ProfessionalException {
        List<String> result = new ArrayList<>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            for (InetAddress inetAddress : inetAddresses) {
                String mac = super.getMacByInetAddress(inetAddress);
                if (StringUtils.isNotBlank(mac))
                    result.add(mac);
            }
        }
        return result;
    }

    /**
     * @description: 获取CPU序列号
     **/
    @Override
    protected String getCPUSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        Scanner scanner = null;
        //序列号
        String serialNumber = null;
        try {

            //使用WMIC获取CPU序列号
            Process process = Runtime.getRuntime().exec("wmic cpu get processorid");
            outputStream = process.getOutputStream();
            scanner = new Scanner(process.getInputStream());
            if (scanner != null && scanner.hasNext()) {
                scanner.next();
            }
            if (scanner.hasNext()) {
                serialNumber = scanner.next().trim();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (scanner != null) {
                try {
                    scanner.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return serialNumber;
    }

    /**
     * @description: 获取主板序列号
     **/
    @Override
    protected String getMainBoardSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        Scanner scanner = null;
        //序列号
        String serialNumber = "";
        try {
            //使用WMIC获取主板序列号
            Process process = Runtime.getRuntime().exec("wmic baseboard get serialnumber");
            outputStream = process.getOutputStream();
            scanner = new Scanner(process.getInputStream());
            if (scanner != null && scanner.hasNext()) {
                scanner.next();
            }
            if (scanner.hasNext()) {
                serialNumber = scanner.next().trim();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (scanner != null) {
                try {
                    scanner.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return serialNumber;
    }
}
