package com.jhscale.common.utils;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.Arrays;

/**
 * @author lie_w
 * @title: AES1281
 * @projectName common
 * @description: TODO
 * @date 2020-10-229:15
 */
public class AES128 {

    private static final Logger logger = LoggerFactory.getLogger(AES128.class);

    // 算法名称
    final String KEY_ALGORITHM = "AES";
    // 加解密算法/模式/填充方式
    final String algorithmStr = "AES/CBC/PKCS7Padding";

    private Key key;
    private Cipher cipher;

    private AES128() {
    }

    public static class Single {
        private static AES128 INSTANCE = new AES128();
    }

    public static AES128 getInstance() {
        return Single.INSTANCE;
    }

    /**
     * 生成密钥
     * 自动生成base64 编码后的AES128位密钥
     */
    public static String buildAESKey() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(128);//要生成多少位，只需要修改这里即可128, 192或256
            SecretKey sk = kg.generateKey();
            byte[] b = sk.getEncoded();
            return ByteUtils.parseByte2HexStr(b);
        } catch (NoSuchAlgorithmException e) {
            logger.error("AES Bulid Invalid", e);
        }
        return null;
    }

    /**
     * 生成IV随机数
     * 生成16位不重复的随机数，含数字+大小写
     **/
    public static String buildIV() {
        return RandomUtils.getGUID();
    }

    private void init(byte[] keyBytes) {
        // 如果密钥不足16位，那么就补足.  这个if 中的内容很重要
        int base = 16;
        if (keyBytes.length % base != 0) {
            int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte) 0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        // 初始化
        Security.addProvider(new BouncyCastleProvider());
        // 转化成JAVA的密钥格式
        key = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        try {
            // 初始化cipher
            cipher = Cipher.getInstance(algorithmStr, "BC");
        } catch (NoSuchAlgorithmException | NoSuchPaddingException | NoSuchProviderException e) {
            logger.error("AES Init Error", e);
        }
    }

    /**
     * 加密方法
     *
     * @param content 要加密的字符串
     * @param aesKey  加密密钥
     * @param iv      偏移量
     * @return
     */
    public byte[] encrypt(byte[] content, byte[] aesKey, byte[] iv) {
        byte[] encrypt = null;
        try {
            init(aesKey);
            cipher.init(Cipher.ENCRYPT_MODE, key, new IvParameterSpec(iv));
            encrypt = cipher.doFinal(content);
        } catch (Exception e) {
            logger.error("AES encrypt Error", e);
        }
        return encrypt;
    }

    /**
     * 加密方法
     *
     * @param content 要加密的字符串
     * @param aesKey  加密密钥
     * @param iv      偏移量
     * @return
     */
    public String encrypt(String content, String aesKey, String iv) {
        return Base64.encode(this.encrypt(content.getBytes(), aesKey.getBytes(), iv.getBytes()));
    }

    /**
     * 解密方法
     *
     * @param encryptedData 要解密的字符串
     * @param aesKey        解密密钥
     * @param iv            偏移量
     * @return
     */
    public byte[] decrypt(byte[] encryptedData, byte[] aesKey, byte[] iv) {
        byte[] decrypt = null;
        init(aesKey);
        try {
            cipher.init(Cipher.DECRYPT_MODE, key, new IvParameterSpec(iv));
            decrypt = cipher.doFinal(encryptedData);
        } catch (Exception e) {
            logger.error("AES decrypt Error", e);
        }
        return decrypt;
    }

    /**
     * 解密方法
     *
     * @param encryptedData 要解密的字符串
     * @param aesKey        解密密钥
     * @param iv            偏移量
     * @return
     */
    public String decrypt(String encryptedData, String aesKey, String iv) {
        try {
            return new String(this.decrypt(Base64.decode(encryptedData), aesKey.getBytes(), iv.getBytes()));
        } catch (Base64DecodingException e) {
            logger.error("AES Base decrypt Error", e);
        }
        return null;
    }

//    public static void main(String[] args) {
//        test1();
//        test2();
//    }
//
//    private static void test1() {
//        String aesKey = AES128.buildAESKey();
//        System.out.println("加密密钥：" + aesKey);
//        String iv = AES128.buildIV();
//        System.out.println("偏移量：" + iv);
//
//        String content = "loginloginloginlogin.html|1234567812345678";
//        String encrypt = AES128.getInstance().encrypt(content, aesKey, iv);
//        System.out.println("加密后的内容：" + encrypt);
//
//        String decrypt = AES128.getInstance().decrypt(encrypt, aesKey, iv);
//        System.out.println("解密后的内容：" + decrypt);
//    }
//
//    private static void test2() {
//        String aesKey = "5D856433627DD6D10D5B5B380649D753";
//        System.out.println("加密密钥：" + aesKey);
//        String iv = "8SI3CVWQ0IX6V4FK";
//        System.out.println("偏移量：" + iv);
//
//        String encrypt = "ygPqtc8ykxnE3TF3Wa3yWow5bqOJ7oXP+NtfFIm3Jfp9t1kEnYNe8UnU+T8Wfxno";
//        String decrypt = new String(AES128.getInstance().decrypt(encrypt, aesKey, iv));
//        System.out.println("解密后的内容：" + decrypt);
//
//        String str = "{\"auditState\":3,\"wechat\":true,\"Alipay\":true,\"company\":\"1\",\"companyName\":\"\",\"userName\":\"\",\"contactName\":\"吕长敏\",\"phone\":\"15010381376\",\"email\":\"6002258223@qq.com\",\"address\":\"义乌市成店路186号\",\"merchantsName\":\"成店路186号 果香园\",\"customerPhone\":\"15010381376\",\"type\":2,\"serviceDesc\":\"保鲜  保质    保量你的满意是我们最大的收获\",\"certificate\":\"0\",\"account\":\"0\",\"alipayAccount\":\"\",\"bankName\":\"\",\"bankId\":\"\",\"foodService\":\"\",\"businessLicense\":\"\",\"organization\":\"\",\"shopSign\":\"\",\"shopInterior\":[],\"idCardIs\":\"\",\"idCardThe\":\"\",\"passport\":\"\"}";
//    }
}
