package com.jhscale.common.utils;

/**
 * @author 王列
 * @Package com.ysscale.common.util
 * @Description: common
 * @date 2018/4/17 23:09
 */
public class ASCIIUtils {

    private ASCIIUtils() {
    }

    public static String convertStringToHex(String str) {
        char[] chars = str.toCharArray();
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < chars.length; i++) {
            hex.append(Integer.toHexString((int) chars[i]));
        }
        return hex.toString();
    }

    public static String convertHexToString(String hex) {
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        //49204c6f7665204a617661 split into two characters 49, 20, 4c...
        for (int i = 0; i < hex.length() - 1; i += 2) {
            //grab the hex in pairs
            String output = hex.substring(i, (i + 2));
            //convert hex to decimal
            int decimal = Integer.parseInt(output, 16);
            //convert the decimal to character
            sb.append((char) decimal);
            temp.append(decimal);
        }
        return sb.toString();
    }

    /**
     * 字符串转换为Ascii
     */
    public static String stringToAscii(String value) {
        StringBuffer sbu = new StringBuffer();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (i != chars.length - 1) {
                sbu.append((int) chars[i]).append(",");
            } else {
                sbu.append((int) chars[i]);
            }
        }
        return sbu.toString();
    }

    /**
     * Ascii转换为字符串
     */
    public static String asciiToString(String value) {
        StringBuffer sbu = new StringBuffer();
        String[] chars = value.split(",");
        for (int i = 0; i < chars.length; i++) {
            sbu.append((char) Integer.parseInt(chars[i]));
        }
        return sbu.toString();
    }

    /**
     * @description: HEX 转 ASCII
     **/
    public static String hex2Ascii(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char) Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    /**
     * @description: ASCII 转 HEX
     **/
    public static String ascii2Hex(String asciiStr) {
        char[] chars = asciiStr.toCharArray();
        StringBuilder hex = new StringBuilder();
        for (char ch : chars) {
            hex.append(Integer.toHexString((int) ch));
        }
        return hex.toString();
    }

    //504F533838383834  POS88884
//    public static void main(String[] args) {
//        System.out.println("\n-----ASCII码转换为16进制 -----");
//        String str = "A";
//        System.out.println("字符串: " + str);
//        String hex = ASCIIUtils.convertStringToHex(str);
//        System.out.println("转换为16进制 : " + hex);
//        System.out.println("\n***** 16进制转换为ASCII *****");
//        System.out.println("Hex : " + hex);
//        System.out.println("ASCII : " + ASCIIUtils.convertHexToString(hex));
//    }
}
