package com.jhscale.common.utils;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/**
 * @author lie_w
 * @title: AesHexUtils
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/159:19
 */
public class AesHexUtils {

    private AesHexUtils() {
    }

    private static final String AES = "AES";

    public static final String AES_ECB_PADDING = "AES/ECB/NoPadding";
    public static final String AES_CBC_PKCS5Padding = "AES/CBC/PKCS5Padding";


    /**
     * @description: AES加密
     **/
    public static byte[] encrypt(byte[] content, String key) {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(Cipher.ENCRYPT_MODE, spec);
            return cipher.doFinal(content);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return encrypt(content, AES_ECB_PADDING, key);
    }

    /**
     * @description: AES加密
     **/
    public static String encrypt(String content, String key) {
        return ByteUtils.toHexString(encrypt(ByteUtils.fromHexString(content), key));
    }

    /**
     * @description: AES解密
     **/
    public static byte[] encrypt(byte[] content, String padding, String key) {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(padding);
            cipher.init(Cipher.ENCRYPT_MODE, spec);
            return cipher.doFinal(content);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new byte[0];
    }


    /**
     * @description: AES解密
     **/
    public static byte[] decrypt(byte[] content, String key) {
        return decrypt(content, AES_ECB_PADDING, key);
    }

    /**
     * @description: AES解密
     **/
    public static String decrypt(String content, String key) {
        return ByteUtils.toHexString(decrypt(ByteUtils.fromHexString(content), key));
    }

    /**
     * @description: AES解密
     **/
    public static byte[] decrypt(byte[] content, String padding, String key) {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(padding);
            cipher.init(Cipher.DECRYPT_MODE, spec);
            return cipher.doFinal(content);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    // public static void main(String[] args) {
    //     String content = "20250711-132610-001-0001-000001-5294158FD96A0713C2038426-0";
    //     byte[] encrypt = encrypt(content.getBytes(), AES_CBC_PKCS5Padding, "C924FC76114FEE2BA3B18E72775F981ED0B3ADA7BBD9F9F1");
    //     System.out.println(ByteUtils.toHexString(encrypt));

    //     String content1 = "20250711-132610-001-0001-000001-5294158FD96A0713C2038426-1346";
    //     byte[] encrypt1 = encrypt(content1.getBytes(), AES_CBC_PKCS5Padding, "C924FC76114FEE2BA3B18E72775F981ED0B3ADA7BBD9F9F1");
    //     System.out.println(ByteUtils.toHexString(encrypt1));

    //     String content2 = "20250711-132610-001-0001-000001-5294158FD96A0713C2038426-45";
    //     byte[] encrypt2 = encrypt(content2.getBytes(), AES_CBC_PKCS5Padding, "C924FC76114FEE2BA3B18E72775F981ED0B3ADA7BBD9F9F1");
    //     System.out.println(ByteUtils.toHexString(encrypt2));

    //     String content3 = "20250711-132610-001-0001-000001-5294158FD96A0713C2038426-46";
    //     byte[] encrypt3 = encrypt(content3.getBytes(), AES_CBC_PKCS5Padding, "C924FC76114FEE2BA3B18E72775F981ED0B3ADA7BBD9F9F1");
    //     System.out.println(ByteUtils.toHexString(encrypt3));
    // }
}
