package com.jhscale.common.utils;

import com.jhscale.common.model.device.Angle;

import java.text.DecimalFormat;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title: AngleUtils
 * @description: 角度计算
 * @date 2025/6/8 20:29
 */
public class AngleUtils {

    /**
     * @param coordinate 当前坐标
     * @param fullScale  满量程
     * @param noise      声噪
     * @param levels     等级
     * @description: 斜角角度
     * @date: 2025-06-08 20:30:20
     **/
    public static Angle oblique(int[] coordinate, int fullScale, int noise, int[] levels) {
        DecimalFormat df = new DecimalFormat("#.00");

        double x = (double) coordinate[0] / noise;
        double y = (double) coordinate[1] / noise;
        double f = (double) fullScale / noise;

        double roll = Math.toDegrees(Math.atan(x / f));
        double pitch = Math.toDegrees(Math.atan(y / f));
        double total = Math.toDegrees(Math.atan(Math.sqrt(x * x + y * y) / f));
        double[] angle = new double[]{
                Double.parseDouble(df.format(roll)),
                Double.parseDouble(df.format(pitch)),
                Double.parseDouble(df.format(total))
        };

        int[] adjust = new int[2];
        int _x = (int) x;
        int _y = (int) y;
        if (_x > 0) {
            adjust = new int[]{1, -1};
        } else if (_x < 0) {
            adjust = new int[]{-1, 1};
        } else {
            if (_y > 0) {
                adjust = new int[]{1, 1};
            } else if (_y < 0) {
                adjust = new int[]{-1, -1};
            }
        }

        double distance = Math.sqrt(coordinate[0] * coordinate[0] + coordinate[1] * coordinate[1]);
        int level = -1;
        for (int i = 0; i < levels.length; i++) {
            if (distance <= levels[i]) {
                level = i;
                break;
            }
        }
        return new Angle(new int[]{_x, _y}, angle, adjust,
                Double.parseDouble(df.format(distance)), level);
    }

    // public static void main(String[] args) {
    //     // 输入参数
    //     double x = -100.0;
    //     double y = -100.0;
    //     double maxRange = 3600.00;

    //     // 1. 计算倾斜角度
    //     double roll = Math.toDegrees(Math.atan(x / maxRange));
    //     double pitch = Math.toDegrees(Math.atan(y / maxRange));
    //     double totalTilt = Math.toDegrees(Math.atan(Math.sqrt(x * x + y * y) / maxRange));

    //     // 2. 有效范围检查
    //     double radius = Math.sqrt(x * x + y * y);
    //     boolean isValid = (radius <= maxRange);

    //     // 3. 水平状态判断
    //     boolean isLevel = (Math.abs(roll) < 1.0 && Math.abs(pitch) < 1.0);

    //     // 输出结果
    //     System.out.println("左右倾斜角 (Roll): " + roll + "°");
    //     System.out.println("前后倾斜角 (Pitch): " + pitch + "°");
    //     System.out.println("总倾斜角度: " + totalTilt + "°");
    //     System.out.println("数据有效: " + isValid);
    //     System.out.println("是否水平: " + isLevel);
    // }
}
