package com.jhscale.common.utils;

import org.apache.commons.codec.binary.Base64;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author 王列
 * @Package com.ysscale.framework.core.utils
 * @Description: ysscale_core
 * @date 2018/5/30 0:17
 */
public class Base64Utils {

    private static final String DEFAULT_ENCODING = "gbk";
    // 字符串编码
    private static final String UTF_8 = "UTF-8";

    private Base64Utils() {
    }

    public static String encode(byte[] bs) {
        return Base64.encodeBase64String(bs);
    }

    public static byte[] decode(String str) {
        return Base64.decodeBase64(str);
    }

    /**
     * 解密字符串
     *
     * @param inputData
     * @return
     */
    public static String decodeData(String inputData) {
        try {
            if (null == inputData) {
                return null;
            }
            return new String(Base64.decodeBase64(inputData.getBytes(UTF_8)), UTF_8);
        } catch (UnsupportedEncodingException e) {
            System.err.println(inputData + "exp: " + e.getMessage());
        }
        return null;
    }

    /**
     * 加密后的字符串
     *
     * @param inputData
     * @return
     */
    public static String encodeData(String inputData) {
        try {
            if (null == inputData) {
                return null;
            }
            return new String(Base64.encodeBase64(inputData.getBytes(UTF_8)), UTF_8);
        } catch (UnsupportedEncodingException e) {
            System.err.println(inputData + "exp: " + e.getMessage());
        }
        return null;
    }

    /**
     * 将字符串压缩后Base64
     *
     * @param primStr 待加压加密函数
     * @return
     */
    public static String gzipString(String primStr) {
        if (primStr == null || primStr.length() == 0) {
            return primStr;
        }
        ByteArrayOutputStream out = null;
        GZIPOutputStream gout = null;
        try {
            out = new ByteArrayOutputStream();
            gout = new GZIPOutputStream(out);
            gout.write(primStr.getBytes(DEFAULT_ENCODING));
            gout.flush();
        } catch (IOException e) {
            System.err.println("对字符串进行加压加密操作失败 exp: " + e.getMessage());
            return null;
        } finally {
            if (gout != null) {
                try {
                    gout.close();
                } catch (IOException e) {
                }
            }
        }
        return new String(com.jhscale.common.utils.Base64.encode(out.toByteArray()));
    }

    /**
     * 将压缩并Base64后的字符串进行解密解压
     *
     * @param compressedStr 待解密解压字符串
     * @return
     */
    public static final String ungzipString(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gin = null;
        String decompressed = null;
        try {
            byte[] compressed = com.jhscale.common.utils.Base64.decode(compressedStr.toCharArray());
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(compressed);
            gin = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = gin.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString(DEFAULT_ENCODING);
        } catch (IOException e) {
            System.err.println("对字符串进行解密解压操作失败 exp: " + e.getMessage());
            decompressed = null;
        } finally {
            if (gin != null) {
                try {
                    gin.close();
                } catch (IOException e) {
                }
            }
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                }
            }
        }
        return decompressed;
    }

//    public static void main(String[] args) {
//        String str = "fsagf4546465sdgfds4中文45g1541hfd4545hg";
//        System.out.println(str);
//        String encoder = gzipString(str);
//        System.out.println(encoder);
//        String decoder = ungzipString(encoder);
//        System.out.println(decoder);
//        String data = "H4sIAAAAAAAAAFNYdkJh2QkTS0tLUz0DAzAHiAxhDDgyMF12whRVCKioGqjPctmlaqXMFCUrcwsDUwMYMDS20FHKS8xNVbJSOvbk9B+l2mWXFMAIbtclcwMDc7h6I2OTZZe2/Ty7/tjvzVvBCiGKFFCREZCsRXYXqpuMMBwOdauZobmZpbm5kaW5gRGyfyFIAQAO++BmBwEAAA==";
//        String decoder2 = ungzipString(data);
//        System.out.println(decoder2);
//    }
}
